% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-xspliner.R
\name{plot.xspliner}
\alias{plot.xspliner}
\title{Plot method for 'xspliner' model}
\usage{
\method{plot}{xspliner}(x, variable_names = NULL, model = NULL,
  plot_response = TRUE, plot_approx = TRUE, data = NULL,
  plot_data = FALSE, plot_deriv = FALSE, n_plots = 6,
  sort_by = NULL, use_coeff = TRUE, compare_with = list(),
  prediction_funs = list(function(object, newdata) predict(object,
  newdata)), ...)
}
\arguments{
\item{x}{Object of class 'xspliner'.}

\item{variable_names}{Names of predictors which transitions should be plotted.}

\item{model}{Base model that xspliner is based on.}

\item{plot_response}{If TRUE black box model response is drawn.}

\item{plot_approx}{If TRUE black box model response approximation is drawn.}

\item{data}{Training data used for building \code{x} model. Required for plot_data option and model comparing.}

\item{plot_data}{If TRUE raw data is drawn.}

\item{plot_deriv}{If TRUE derivative of approximation is showed on plot.}

\item{n_plots}{Threshold for number of plots when plotting all variables.}

\item{sort_by}{When comparing models determines according to which model should observations be ordered.}

\item{use_coeff}{If TRUE both PDP function and its approximation is scaled with corresponding surrogate model coefficient.}

\item{compare_with}{Named list. Other models that should be compared with xspliner and \code{model}.}

\item{prediction_funs}{Prediction functions that should be used in model comparison.}

\item{...}{Another arguments passed into model specific method.}
}
\description{
The method provides all plotting methods offered by 'xspliner' package.
See \link{plot_variable_transition} and \link{plot_model_comparison} for more details.
}
