% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtracto.R
\name{xtracto}
\alias{xtracto}
\title{Extract environmental data along a trajectory using ERDDAP.}
\usage{
xtracto(dtype, xpos, ypos, tpos = NA, xlen = 0, ylen = 0,
  verbose = FALSE)
}
\arguments{
\item{dtype}{- number or string identifying the ERDDAP parameter to extract}

\item{xpos}{- a real array with the longitudes of the trajectory (in decimal
degrees East, either 0-360 or -180 to 180)}

\item{ypos}{-  a real array with the latitudes of the trajectory (in decimal
degrees N; -90 to 90)}

\item{tpos}{- character array with the times of the trajectory in
"YYYY-MM-DD". Default is NA for no time.}

\item{xlen}{- optional real array defining the longitude box around the given point (xlen/2 around the point).  Default 0.}

\item{ylen}{- optional real array defining the latitude box around the given point (tlen/2 around the point). Default 0.}

\item{verbose}{- optional logical for verbose download out, default FALSE}
}
\value{
A dataframe containing:
\itemize{
 \item column 1 = mean of data within search radius
 \item column 2 = standard deviation of data within search radius
 \item column 3 = number of points found within search radius
 \item column 4 = time of returned value
 \item column 5 = min longitude of call (decimal degrees)
 \item column 6 = max longitude of call (decimal degrees)
 \item column 7 = min latitude of call (decimal degrees)
 \item column 8 = max latitude of call (decimal degrees)
 \item column 9 = requested time in tag
 \item column 10 = median of data within search radius
 \item column 11 = median absolute deviation of data within search radius
 }
}
\description{
\code{xtracto} uses the ERD ERDDAP data web service to extact environmental
data along a longitude, latitude and time trajectory
}
\examples{
xpos <- c(230, 235)
ypos <- c(40, 45)
tpos <- c('2006-01-15', '2006-01-20')
xlen <- 0.025
ylen <- 0.025
extract <- xtracto('erdMBsstd8day', xpos, ypos, tpos = tpos, xlen = xlen, ylen = ylen)

}
