% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimations.R
\name{estimate.people}
\alias{estimate.people}
\alias{estimate.people.3pl.eap}
\alias{estimate.people.3pl.map}
\alias{estimate.people.3pl.mle}
\title{Estimation of People Parameters}
\usage{
estimate.people(responses, items, model = "3pl", method = "mle", ...)

estimate.people.3pl.mle(responses, items, init = 0, iter = 30,
  conv = 0.01, bound = 3.5, debug = FALSE)

estimate.people.3pl.map(responses, items, prior.mu = 0, prior.sig = 1,
  init = 0, iter = 15, conv = 0.01, bound = 3.5, debug = FALSE)

estimate.people.3pl.eap(responses, items)
}
\arguments{
\item{responses}{a data frame of responses}

\item{items}{a data frame of item parameters}

\item{model}{the IRT model}

\item{method}{the estimation method}

\item{...}{further arguments}

\item{init}{initial values of people parameters, a number or a vector}

\item{iter}{the maximum of iterations}

\item{conv}{convergence criterion}

\item{bound}{the bounds of resulting people parameters}

\item{debug}{\code{TRUE} to turn on debug mode}

\item{prior.mu}{the mean of the prior distribuiton}

\item{prior.sig}{the standard deviation of the prior distribution}
}
\value{
a data frame of estimated people parameters
}
\description{
\code{estimate.people} is a wrapper function for estimating people parameters

\code{estimate.people.3pl.mle} estimates people parameters with known item parameters using maximum likelihood estimation.

\code{estimate.people.3pl.map} estimates people parameters with known item parameters using maximum a posterior.

\code{estimate.3pl.theta.eap} estimates people parameters with known item parameters using expected a posterior.
}
\details{
The debug mode draws a convergence curve. \cr
For the maximum likelihood estimation, refer to Baker and Kim (2004), pp. 66-69.

For the maximum a posteriori estimation, refer to Baker and Kim (2004), pp. 192.

For the expected a posteriori, refer to Baker and Kim (2004), pp. 193.
}
\examples{
\dontrun{
# data generation
data <- irt.model(model="3pl")$gen.data(500, 50)
# MLE
x <- estimate.people(data$responses, data$items, "3pl", "mle", debug=TRUE)
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.5), pch=16)
# MAP
x <- estimate.people(data$responses, data$items, "3pl", "map", debug=TRUE)
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.5), pch=16)
# EAP
x <- estimate.people(data$responses, data$items, "3pl", "eap")
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.5), pch=16)
}
\dontrun{
# data generation
data <- irt.model(model="3pl")$gen.data(500, 50)
# MLE
x <- estimate.people.3pl.mle(data$responses, data$items, debug=TRUE)
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.5), pch=16)
# MAP
x <- estimate.people.3pl.map(data$responses, data$items, debug=TRUE)
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.5), pch=16)
# EAP
x <- estimate.people.3pl.eap(data$responses, data$items)
cor(data$people$theta, x$people$theta)
plot(data$people$theta, x$people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.5), pch=16)
}
}

