#' Calculate predicted values of GRNN 
#'
#' The function \code{grnn.predict} calculates a vector of GRNN predicted values based on an input matrix
#'
#' @param net  The GRNN object generated by grnn.fit() 
#' @param x    The matrix of input predictors 
#'
#' @return A vector of predicted values
#'
#' @seealso \code{\link{grnn.predone}}
#'
#' @examples
#' data(iris, package = "datasets")
#' Y <- ifelse(iris[, 5] == "setosa", 1, 0)
#' X <- scale(iris[, 1:4])
#' gnet <- grnn.fit(x = X, y = Y)
#' grnn.predict(gnet, X[seq(5), ])

grnn.predict <- function(net, x) {
  if (class(net) != "General Regression Neural Net") stop("net needs to be a GRNN.", call. = F)
  if (is.matrix(x) == F) stop("x needs to be a matrix.", call. = F)
  if (anyNA(x) == T) stop("NA found in x.", call. = F)
  if (ncol(x) != ncol(net$x)) stop("x dimension is not consistent with grnn.", call. = F)
  return(Reduce(c, lapply(split(x, seq(nrow(x))), function(x_) grnn.predone(net, x_))))
}
