% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvec.R
\name{as.data.frame.dvec}
\alias{as.data.frame.dvec}
\title{Coerce Decorated Vector to Data Frame}
\usage{
\method{as.data.frame}{dvec}(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  nm = deparse1(substitute(x))
)
}
\arguments{
\item{x}{dvec}

\item{row.names}{passed to next method}

\item{optional}{passed to next method}

\item{...}{passed to next method}

\item{nm}{name for new column}
}
\value{
data.frame
}
\description{
Coerces decorated vector to data.frame.
}
\examples{
as.data.frame(as_dvec(letters[1:3]))
L <- as_dvec(letters[1:3], label = 'My Letters')
d <- data.frame(letters = L )
str(d)
}
\seealso{
Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{as_dvec}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.dvec}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\keyword{internal}
