% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical.R
\name{canonical.decorated}
\alias{canonical.decorated}
\alias{canonical}
\title{Sort Decorations}
\usage{
\method{canonical}{decorated}(
  x,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  ...
)
}
\arguments{
\item{x}{decorated}

\item{default_keys}{attribute names in preferred order}

\item{...}{ignored}
}
\value{
decorated
}
\description{
Enforces canonical attribute order for class 'decorated'.
Set of default_keys will be augmented with all observed attribute names
and will be expanded or reduced as necessary for each
data item.
}
\examples{
# make some decorated data
library(magrittr)
x <- data.frame(x = 1, y = 1, z = factor('a'))
x \%<>\% decorate('
x: [ guide: mm, desc: this, label: foo ]
"y": [ guide: bar, desc: other ]
')

# retrieve decorations: label not first!
decorations(x)

# sort label first by default
decorations(canonical(x))

# equivalent invocation
canonical(decorations(x))

}
\seealso{
Other canonical: 
\code{\link{canonical.yamlet}()},
\code{\link{canonical_generic}}

Other interface: 
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{canonical}
\concept{interface}
