% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{decorations_groups.data.frame}
\alias{decorations_groups.data.frame}
\alias{decorations_groups}
\title{Recover Groups Decorations for Data Frame}
\usage{
\method{decorations_groups}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{ignored}
}
\value{
character: names of groups columns
}
\description{
Recovers groups decorations for class 'data.frame'.
Seeks a sequentially-valued integer attribute 
with name 'groups' for each column, sorts these,
and returns a character vector like \code{group_vars(x)}.
}
\examples{
library(magrittr)
library(dplyr)
Theoph \%<>\% group_by(Subject, Time)
Theoph \%>\% group_vars
Theoph \%>\% decorations_groups # nothing!
Theoph \%<>\% decorate_groups
Theoph \%>\% decorations_groups # something!
Theoph \%<>\% ungroup
Theoph \%>\% group_vars # gone!
Theoph \%<>\% group_by(across(all_of(decorations_groups(.))))
Theoph \%>\% group_vars # recovered!
Theoph \%<>\% group_by_decorations
Theoph \%>\% group_vars # same
rm(Theoph)

}
\seealso{
Other decorate: 
\code{\link{as_decorated.default}()},
\code{\link{as_decorated}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorate_generic}},
\code{\link{decorate_groups.data.frame}()},
\code{\link{decorate_groups_generic}},
\code{\link{decorations.data.frame}()},
\code{\link{decorations_generic}},
\code{\link{decorations_groups_generic}},
\code{\link{group_by_decorations.data.frame}()},
\code{\link{group_by_decorations_generic}},
\code{\link{redecorate}()}
}
\concept{decorate}
