% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{as_lab.list}
\alias{as_lab.list}
\title{Coerce List to Axis Label}
\usage{
\method{as_lab}{list}(x, default, collapse = "\\n",
  enclose = getOption("enclose", default = c("(", ")")), ...)
}
\arguments{
\item{x}{list, such as returned by \code{\link{attributes}}.}

\item{default}{a value to return by default}

\item{collapse}{character: separator for collapsing multi-line units}

\item{enclose}{length-two character for enclosing unit}

\item{...}{ignored}
}
\value{
length-one character
}
\description{
Coerces list to axis label.
}
\examples{
meta <- system.file(package = 'yamlet', 'extdata','yamlet.csv')
x <- decorate(meta)
as_lab(attributes(x$TIME), 'TIME', enclose = c('[',']'))
}
\seealso{
Other lab: \code{\link{agplot}}, \code{\link{as_lab}},
  \code{\link{print.ag}}
}
\concept{lab}
