% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{print.decorated_ggplot}
\alias{print.decorated_ggplot}
\title{Substitute Expressions, Titles, Labels and Aesthetics in ggplots}
\usage{
\method{print}{decorated_ggplot}(
  x,
  ...,
  search = getOption("yamlet_decorated_ggplot_search", c("expression", "title", "label")),
  discrete = getOption("yamlet_decorated_ggplot_discrete", c("colour", "fill", "size",
    "shape", "linetype", "linewidth", "alpha")),
  drop = getOption("yamlet_decorated_ggplot_drop", TRUE)
)
}
\arguments{
\item{x}{class 'decorated_ggplot' from \code{\link{ggplot.decorated}}}

\item{...}{ignored}

\item{search}{attribute names from which to seek label substitutes}

\item{discrete}{discrete aesthetics to map from data decorations where available}

\item{drop}{should unused factor levels be omitted from data-driven discrete scales?}
}
\value{
see \code{\link[ggplot2]{print.ggplot}}
}
\description{
Default labels (e.g. mappings for \code{x}, \code{y}, etc.)
will be used to search \code{data} for more meaningful
labels, taking first available from attributes
with names in \code{search}.  Likewise, if mappings for 
colour (color), fill, size, etc. (see defaults for \code{discrete})
indicate columns that have these defined as attributes, 
an attempt is made to add a corresponding discrete scale if
one does not exist already. Values are recycled if necessary
and are specific by ordinal position to the corresponding
level of the corresponding variable.  Levels are defined
in increasing priority by
\code{sort(unique(x))},
any guide attribute,
any factor levels,
any codelist attribute, or
any plotmath attribute.
}
\examples{
example(ggplot.decorated)
}
\seealso{
Other decorated_ggplot: 
\code{\link{ggplot.decorated}()},
\code{\link{ggplot_build.decorated_ggplot}()}
}
\concept{decorated_ggplot}
