% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.optmiz_logl.R
\name{pnn.optmiz_logl}
\alias{pnn.optmiz_logl}
\title{Optimize the optimal value of PNN smoothing parameter based on the cross entropy}
\usage{
pnn.optmiz_logl(net, lower = 0, upper, nfolds = 4, seed = 1, method = 1)
}
\arguments{
\item{net}{A PNN object generated by pnn.fit()}

\item{lower}{A scalar for the lower bound of the smoothing parameter, 0 by default}

\item{upper}{A scalar for the upper bound of the smoothing parameter}

\item{nfolds}{A scalar for the number of n-fold, 4 by default}

\item{seed}{The seed value for the n-fold cross-validation, 1 by default}

\item{method}{A scalar referring to the optimization method, 1 for Golden section searc and 2 for Brent's method}
}
\value{
The best outcome
}
\description{
The function \code{pnn.optmiz_logl} optimize the optimal value of PNN smoothing parameter by cross-validation.
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
\donttest{
pnn.optmiz_logl(pnet, upper = 1)
}
}
\seealso{
\code{\link{pnn.search_logl}}
}
