% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv-roc_curve_survival.R
\name{roc_curve_survival}
\alias{roc_curve_survival}
\alias{roc_curve_survival.data.frame}
\title{Time-Dependent ROC surve for Censored Data}
\usage{
roc_curve_survival(data, ...)

\method{roc_curve_survival}{data.frame}(data, truth, ..., na_rm = TRUE, case_weights = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{The column identifier for the survival probabilities this
should be a list column of data.frames corresponding to the output given when
predicting with {censored} model. This should be an unquoted column name
although this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column names). For
\verb{_vec()} functions, a numeric vector. See Details below.}

\item{truth}{The column identifier for the true survival result (that
is created using \code{\link[survival:Surv]{survival::Surv()}}.). This should be an unquoted column name
although this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column names). For
\verb{_vec()} functions, an \code{\link[survival:Surv]{survival::Surv()}} object.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}
}
\value{
A tibble with class \code{roc_survival_df}, \code{grouped_roc_survival_df} having
columns \code{.threshold}, \code{sensitivity}, \code{specificity}, and \code{.eval_time}.
}
\description{
Compute the ROC survival curve using predicted survival probabilities that
corresponds to different time points.
}
\details{
This formulation takes survival probability predictions at one or more
specific \emph{evaluation times} and, for each time, computes the ROC curve. To
account for censoring, inverse probability of censoring weights (IPCW) are
used in the calculations. See equation 7 of section 4.3 in Blanche \emph{at al}
(2013) for the details.

The column passed to \code{...} should be a list column with one element per
independent experiential unit (e.g. patient). The list column should contain
data frames with several columns:
\itemize{
\item \code{.eval_time}: The time that the prediction is made.
\item \code{.pred_survival}: The predicted probability of survival up to \code{.eval_time}
\item \code{.weight_censored}: The case weight for the inverse probability of censoring.
}

The last column can be produced using \code{\link[parsnip:censoring_weights]{parsnip::.censoring_weights_graf()}}.
This corresponds to the weighting scheme of  Graf \emph{et al} (1999). The
internal data set \code{lung_surv} shows an example of the format.

This method automatically groups by the \code{.eval_time} argument.
}
\examples{
result <- roc_curve_survival(
  lung_surv,
  truth = surv_obj,
  .pred
)
result

# ---------------------------------------------------------------------------
# `autoplot()`

# Visualize the curve using ggplot2 manually
library(ggplot2)
library(dplyr)
result \%>\%
  mutate(.eval_time = format(.eval_time)) \%>\%
  ggplot(aes(
    x = 1 - specificity, y = sensitivity,
    group = .eval_time, col = .eval_time
  )) +
  geom_step(direction = "hv") +
  geom_abline(lty = 3) +
  coord_equal() +
  theme_bw()

# Or use autoplot
autoplot(result)
}
\references{
Blanche, P., Dartigues, J.-F. and Jacqmin-Gadda, H. (2013), Review and
comparison of ROC curve estimators for a time-dependent outcome with
marker-dependent censoring. \emph{Biom. J.}, 55: 687-704.

Graf, E., Schmoor, C., Sauerbrei, W. and Schumacher, M. (1999), Assessment
and comparison of prognostic classification schemes for survival data.
\emph{Statist. Med.}, 18: 2529-2545.
}
\seealso{
Compute the area under the ROC survival curve with \code{\link[=roc_auc_survival]{roc_auc_survival()}}.
}
\author{
Emil Hvitfeldt
}
\concept{survival curve metrics}
\keyword{internal}
