% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write.arff}
\alias{write.arff}
\title{Write a data.frame onto an ARFF file}
\usage{
write.arff(x, relation = NULL, types = NULL, file = "",
  sparse = FALSE, append = FALSE, ...)
}
\arguments{
\item{x}{A data.frame}

\item{relation}{Name of the dataset (optional, it may be inferred from the
\code{relation} attribute or the name of the variable passed as argument)}

\item{types}{A character vector indicating the type of each variable
(optional, may be inferred from the \code{attributes} attribute or computed from
the class of each variable)}

\item{file}{Name of the file where the data is to be written. Use \code{""} to
write to standard output}

\item{sparse}{Logical: write in sparse format?}

\item{append}{Logical: append to an existing file?}

\item{...}{Extra parameters for internal functions}
}
\value{
Invisibly, the name of the file.
}
\description{
Takes a data frame and records it in ARFF (Attribute-Relation
File Format).
}
\examples{

library(yarr)
\donttest{
write.arff(iris, "iris", file = tempfile())
}
}
