% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_citations.R
\name{yml_reference}
\alias{yml_reference}
\alias{reference}
\title{Write references as YAML fields}
\usage{
yml_reference(.yml, ..., .bibentry = NULL)

reference(id = NULL, ...)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{...}{Fields relevant to the citation (e.g. bibtex fields)}

\item{.bibentry}{An object created by \code{bibentry()} or \code{citation()}. Note that
this requires pandoc-citeproc to be installed.}

\item{id}{a character vector to use as the reference ID}
}
\value{
a \code{yml} object
}
\description{
\code{yml_reference()} creates YAML fields for references to be used in citation.
\code{reference()} is a simple function to add references to \code{yml_reference()}. The
easiest way to add references to an R Markdown file is to use a bibliography
file, such as .bib, in the \code{bibliography} field (see \code{\link[=yml_citations]{yml_citations()}}). For
documents with very few references, however, it might be useful to make the
references self-contained in the YAML. \code{yml_reference()} can also transform to
YAML \code{bibentry} and \code{citation} objects created by\code{\link[=bibentry]{bibentry()}} and
\code{\link[=citation]{citation()}}. To cite many R packages and convert the references to YAML,
it may be better to use \code{\link[knitr:write_bib]{knitr::write_bib()}} to write a bibliography file and
convert it with \code{\link[=bib2yml]{bib2yml()}}.
}
\examples{

ref <- reference(
  id = "fenner2012a",
  title = "One-click science marketing",
  author = list(
    family = "Fenner",
    given = "Martin"
  ),
  `container-title` = "Nature Materials",
  volume = 11L,
  URL = "http://dx.doi.org/10.1038/nmat3283",
  DOI = "10.1038/nmat3283",
  issue = 4L,
  publisher = "Nature Publishing Group",
  page = "261-263",
  type = "article-journal",
  issued = list(
    year = 2012,
    month = 3
  )
)

yml() \%>\%
  yml_reference(ref)

# from ?bibentry
bref <- c(
   bibentry(
     bibtype = "Manual",
     title = "boot: Bootstrap R (S-PLUS) Functions",
     author = c(
       person("Angelo", "Canty", role = "aut",
         comment = "S original"),
       person(c("Brian", "D."), "Ripley", role = c("aut", "trl", "cre"),
         comment = "R port, author of parallel support",
         email = "ripley@stats.ox.ac.uk")
     ),
     year = "2012",
     note = "R package version 1.3-4",
     url = "https://CRAN.R-project.org/package=boot",
     key = "boot-package"
   ),

   bibentry(
     bibtype = "Book",
     title = "Bootstrap Methods and Their Applications",
     author = as.person("Anthony C. Davison [aut], David V. Hinkley [aut]"),
     year = "1997",
     publisher = "Cambridge University Press",
     address = "Cambridge",
     isbn = "0-521-57391-2",
     url = "http://statwww.epfl.ch/davison/BMA/",
     key = "boot-book"
   )
)
\donttest{
# requires pandoc-citeproc to be installed
yml() \%>\%
  yml_reference(.bibentry = bref)

yml() \%>\%
  yml_reference(.bibentry = citation("purrr"))
}
}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_toc}()},
\code{\link{yml_vignette}()}

Other citations: 
\code{\link{bib2yml}()},
\code{\link{yml_citations}()}
}
\concept{citations}
\concept{yml}
