% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBattingScoredcardOppnAllMatches.R
\name{teamBattingScorecardOppnAllMatches}
\alias{teamBattingScorecardOppnAllMatches}
\title{Team batting scorecard of a team in all matches against an opposition}
\usage{
teamBattingScorecardOppnAllMatches(matches,main,opposition)
}
\arguments{
\item{matches}{the data frame of all matches between a team and an opposition obtained with
the call getAllMatchesBetweenteam()}

\item{main}{The main team for which scorecard required}

\item{opposition}{The opposition team}
}
\value{
scorecard
The scorecard of all the matches
}
\description{
This function computes returns the batting scorecard (runs, fours, sixes, balls played) for the
team in all matches against an opposition
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India and Australia
matches <- getAllMatchesBetweenTeams("India","Australia",dir="../data",save=TRUE)
# Compute the scorecard of India in matches with australia
teamBattingScorecardOppnAllMatches(matches,main="India",opposition="Australia")

#Get all matches between Australia and India
matches <- getAllMatchesBetweenTeams("Australia","India",dir="../data")
#Compute the batting scorecard of Australia
teamBattingScorecardOppnAllMatches(matches,"Australia","India")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
}
\author{
Tinniam V Ganesh
}
