% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_yaml_dir.R
\name{extract_yaml_dir}
\alias{extract_yaml_dir}
\title{Extract all YAML fragments from all files in a directory}
\usage{
extract_yaml_dir(path, recursive = TRUE,
  fileRegexes = c("^[^\\\\.]+.*$"), delimiterRegEx = "^---$",
  ignoreOddDelimiters = FALSE, encoding = "UTF-8", silent = TRUE)
}
\arguments{
\item{path}{The path containing the files.}

\item{recursive}{Whether to also process subdirectories (\code{TRUE})
or not (\code{FALSE}).}

\item{fileRegexes}{A vector of regular expressions to match the files
against: only files matching one or more regular expressions in this
vector are processed. The default regex (\code{^[^\.]+.*$}) matches all
files except those that start with a period (\code{.}).}

\item{delimiterRegEx}{The regular expression used to locate YAML
fragments.}

\item{ignoreOddDelimiters}{Whether to throw an error (FALSE) or
delete the last delimiter (TRUE) if an odd number of delimiters is
encountered.}

\item{encoding}{The encoding to use when calling \code{\link[=readLines]{readLines()}}. Set to
NULL to let \code{\link[=readLines]{readLines()}} guess.}

\item{silent}{Whether to be silent (\code{TRUE}) or informative (\code{FALSE}).}
}
\value{
A list of character vectors.
}
\description{
These function extracts all YAML fragments from all files in a
directory returning a list of character vectors containing the
extracted fragments.
}
\examples{
### First get the directory where 'yum' is installed
yumDir <- system.file(package="yum");
### Specify the path of some example files
examplePath <- file.path(yumDir, "extdata");
### Show files (should be three .dct files)
list.files(examplePath);
### Load these files
yum::extract_yaml_dir(path=examplePath);
}
