% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_yaml_list.R
\name{load_yaml_list}
\alias{load_yaml_list}
\title{Load all YAML fragments from all character vectors in a list}
\usage{
load_yaml_list(x, recursive = TRUE, select = ".*",
  delimiterRegEx = "^---$", ignoreOddDelimiters = FALSE,
  encoding = "UTF-8", silent = TRUE)
}
\arguments{
\item{x}{The list containing the character vectors.}

\item{recursive}{Whether to first \code{unlist} the list (\code{TRUE})
or not (\code{FALSE}).}

\item{select}{A vector of regular expressions specifying object names
to retain. The default (\code{.*}) matches everything, so by default, all
objects are retained.}

\item{delimiterRegEx}{The regular expression used to locate YAML
fragments.}

\item{ignoreOddDelimiters}{Whether to throw an error (FALSE) or
delete the last delimiter (TRUE) if an odd number of delimiters is
encountered.}

\item{encoding}{The encoding to use when calling \code{\link[=readLines]{readLines()}}. Set to
NULL to let \code{\link[=readLines]{readLines()}} guess.}

\item{silent}{Whether to be silent (\code{TRUE}) or informative (\code{FALSE}).}
}
\value{
A list of lists of objects.
}
\description{
These function extracts all YAML fragments from character vectors
in a list, returning a list of character vectors containing the
extracted fragments.
}
\details{
This function calls \code{\link[yaml:yaml.load]{yaml::yaml.load()}} on all character vectors
in a list. It then returns a list where each element is a list
with the parsed fragments in a file.
}
\examples{
yamlList <- list(c(
"---",
"-",
"  id: firstFragment",
"---"), c(
"---",
"-",
"  id: secondFragment",
"  parentId: firstFragment",
"---"));
yum::load_yaml_list(yamlList);
}
