% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_recipes}
\alias{search_recipes}
\title{Search recipes on Yummly.com}
\usage{
search_recipes(search_words, require_pictures, allowed_ingredient,
  excluded_ingredient, allowed_diet, allowed_allergy, allowed_cuisine,
  excluded_cuisine, allowed_course, excluded_course, allowed_holiday,
  excluded_holiday, max_total_time, max_results, start, nutrition, flavor,
  facet_field, app_id = auth_cache$APP_ID, app_key = auth_cache$APP_KEY)
}
\arguments{
\item{search_words}{search phrase, can be supplied in from of vector of words}

\item{require_pictures}{set to \code{TRUE} if only to return recipes with photos}

\item{allowed_ingredient}{ingredient that all search results must include}

\item{excluded_ingredient}{ingredient that all search results should not contain}

\item{allowed_diet}{search results will only include recipes whose ingredients are allowed for that diet}

\item{allowed_allergy}{only include recipes whose ingredients are allowed for that allergy}

\item{allowed_cuisine}{search results will only include recipes with that cuisine}

\item{excluded_cuisine}{search results will only exclude recipes with that cuisine}

\item{allowed_course}{search results will only include recipes with that cuisine}

\item{excluded_course}{search results will only exclude recipes with that cuisine}

\item{allowed_holiday}{search results will only include recipes with that holiday}

\item{excluded_holiday}{search results will only exclude recipes with that holiday}

\item{max_total_time}{search for recipes that do not exceed a specified max total cook + prep time in seconds}

\item{max_results}{number of results to return}

\item{start}{start with specific result in search}

\item{nutrition}{set the range of allowed values for a given nutrition attribute (see below for the list of supported nutrition attributes) by setting a min and/or a max}

\item{flavor}{set the ranges for taste attributes (this corresponds to the taste sliders on the Yummly.com search page). The values of min and max are between 0 and 1.}

\item{facet_field}{facet counts for ingredient and diet. When this parameter is called, the response will include a facetCounts object that lists the matching diets or ingredients and how many results match each diet or ingredient.}

\item{app_id}{application ID}

\item{app_key}{application key}
}
\description{
Query Yummly.com API to search for recipes with certain parameter. All parameters are optional and can be used in any combination.
The criteria you pass via the various parameters are combined with the AND operator (set conjunction). In other words, every recipe has to match the search phrase and satisfy the ingredient, cuisine, course, holiday, time, nutrition, and taste restrictions as described below.
If you specify a multi-word phrase to the q parameter, every word has to match something in each matching recipe:
}
\note{
This function resembles search query to Yummly API
}
\examples{
\dontrun{
# search for recipes with bacon
search_recipes("bacon")

# search for recipes with bacon that have pictures
search_recipes("bacon", require_pictures = TRUE)

# search for "Onion Soup" recipes which include garlic and cognac
search_recipes("Onion Soup", allowed_ingredient = c("garlic", "cognac"))

# search for "Onion Soup" recipes which do not include "onion soup mix" 
search_recipes("Onion Soup", excluded_ingredient = c("onion soup mix"))

# search for "Onion Soup" recipes that are Dairy-Free and Gluten-Free
search_recipes("bacon", allowed_allergy =c("Dairy-Free", "Gluten-Free"))

# search for "Onion Soup" recipes that are Pescetarian and Lacto vegetarian
search_recipes("bacon", allowed_diet =c("Pescetarian", "Lacto vegetarian")

# search for "Onion Soup" recipes that match American Cuisine
search_recipes("bacon", allowed_cuisine =c("American")

# exclude American recipes from a search for "Onion Soup"
search_recipes("bacon", excluded_cuisine =c("American")

# search for "Onion Soup" recipes that are Appetizers
search_recipes("bacon", allowed_course =c("Appetizers")

# exclude Appetizer recipes from a search for "Onion Soup" 
search_recipes("bacon", excluded_course =c("Appetizers")

# search for "Onion Soup" recipes for Thanksgiving 
search_recipes("bacon", allowed_holiday =c("Thanksgiving")

# exclude Thanksgiving recipes from a search for "Onion Soup"
search_recipes("bacon", excluded_holiday =c("Thanksgiving")

# if you want 20 recipes per page and want to see the second page of results
search_recipes("bacon", max_results = 20)

# if you want to start with position 20
search_recipes("bacon", start = 20)

# looking for recipes with a lot of Potassium, try setting a min of 3000 mg
# and a max of the Daily Suggested Value of 3500 mg
search_recipes("bacon", nutrition = list(Calcium=list(min=3, max=3.5)))

#  search for recipes which are very sweet but are not very spicy,
search_recipes("bacon", flavor = list(sweet=list(min=0.1, max=1)))
}
}
\references{
\itemize{
  \item Yummly Developer Guide \url{https://developer.yummly.com/documentation}
}
}

