% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{vport}
\alias{vport}
\title{Viewport Constructing Function for Grid Functions}
\usage{
vport(ispace, xlim = NULL, ylim = NULL, x = NULL, y = NULL, ...)
}
\arguments{
\item{ispace}{inner space (in \eqn{[0,1]}))}

\item{xlim}{x-axis limits; if  \code{NULL}, the data limits are used.}

\item{ylim}{y-axis limits; if  \code{NULL}, the data limits are used.}

\item{x}{x data (only used if \code{is.null(xlim)});
if \code{NULL}, \code{0:1} is used.}

\item{y}{y data (only used if \code{is.null(ylim)}); if \code{NULL}, \code{0:1} is used.}

\item{...}{additional arguments passed to the underlying \code{\link{viewport}()}.}
}
\value{
The \code{\link{viewport}}.
}
\description{
Auxiliary function for constructing viewports 
for 1d and 2d (default) plots.
}
\details{
This is an auxiliary function used by the provided 
\pkg{grid}-related 1d and 2d plots.
}
\note{
Ideas from dataViewport() and extendrange()
      Omitted check:
      if(length(ispace) != 4) ispace <- rep(ispace, length.out = 4)
      stopifnot(0 <= ispace, ispace <= 1)
}
\seealso{
Other graphical tools: \code{\link{l_ispace_config}},
  \code{\link{na_omit_loon}}, \code{\link{plot_region}},
  \code{\link{zenarrow}}
}
\author{
Marius Hofert
}
\concept{graphical tools}
\keyword{dplot}
