% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zerotradeflow.R
\docType{data}
\name{same}
\alias{same}
\title{Dataset composed of five different countries (BRA appears as both exporter
and importer).}
\format{
A dataframe object.
}
\usage{
same
}
\value{
a dataframe object contains the five variables passed as parameters
to the get_zerotradeflow() function (year, exporter, importer, item, trade)
including the bilateral trade flow equal to zero.
}
\description{
A dummy dataset to illustrate the final size of the base after
expansion.
}
\details{
A dataset cosisting of three years, three exporting countries,
three importing countries, three Harmonized System code and value of exports
(all data is fictitious). The data includes the following fields:

* ano - Numeric. Year in which exports were carried out.
* ido - String. ISO code corresponding to the exporting country.
* idd - String. ISO code corresponding to the importing country.
* HS4 - Numeric. HS4 code corresponding to the merchandise sold.
* comercio - Numeric. Dollar value of exports.
}
\examples{

# On the other hand, in the same.rda base, Brazil (BRA) appears as both an
# exporter and an importer and, in this case, when expanding the base, there
# are 72 observations as a result.


\donttest{

sameflow <- get_zerotradeflow(same, ano, ido, idd, HS4, comercio)

}


}
\keyword{datasets}
