% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Plot.zeta.decline}
\alias{Plot.zeta.decline}
\title{Zeta diversity decline plotting}
\usage{
Plot.zeta.decline(zeta, sd.plot = TRUE, arrange.plots = TRUE)
}
\arguments{
\item{zeta}{A list produced by the function \code{Zeta.decline.mc} or \code{Zeta.decline.ex}.}

\item{sd.plot}{Boolean value (TRUE or FALSE) indicating if the standard deviation of each zeta diversity value must be plotted.}

\item{arrange.plots}{Boolean value (TRUE or FALSE) indicating if the graphics device must be divided into 4 subplots.}
}
\value{
A plot of the zeta decline with 4 subplots displaying (i) the raw decline, (ii) the ratios of the zeta values (computed as \eqn{\zeta_i / \zeta_{i-1}}), (iii) the fit in a log plot and (iv) the fit in a log-log plot.
}
\description{
Plots the output of the functions \code{Zeta.decline.mc} and \code{Zeta.decline.ex}.
}
\examples{

utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[1:2]
data.spec.bird <- bird.spec.coarse[3:193]

dev.new(width = 12, height = 4)
zeta.bird <- Zeta.decline.mc(data.spec.bird, orders = 1:5, sam=100, plot = FALSE)
Plot.zeta.decline(zeta.bird)

##########

utils::data(Marion.species)
xy.marion <- Marion.species[1:2]
data.spec.marion <- Marion.species[3:33]

dev.new(width = 12, height = 4)
zeta.marion <- Zeta.decline.ex(data.spec.marion, orders = 1:5, plot = FALSE)
Plot.zeta.decline(zeta.marion)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}
}
