% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpe.R
\name{zipfpe}
\alias{zipfpe}
\alias{dzipfpe}
\alias{dzipfpe}
\alias{pzipfpe}
\alias{qzipfpe}
\alias{rzipfpe}
\title{The Zipf-Poisson Extreme Distribution (Zipf-PE).}
\usage{
dzipfpe(x, alpha, beta, log = FALSE)

pzipfpe(q, alpha, beta, log.p = FALSE, lower.tail = TRUE)

qzipfpe(p, alpha, beta, log.p = FALSE, lower.tail = TRUE)

rzipfpe(n, alpha, beta)
}
\arguments{
\item{x, q}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1} ).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta\in (-\infty, +\infty)} ).}

\item{log, log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{Logical; if TRUE (default), probabilities are \eqn{P[X \leq x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random values to return.}
}
\value{
{
\code{dzipfpe} gives the probability mass function,
\code{pzipfpe} gives the cumulative function,
\code{qzipfpe} gives the quantile function, and
\code{rzipfpe} generates random values from a Zipf-PE distribution.  }
}
\description{
Probability mass function, cumulative distribution function, quantile function and random number
generation for the Zipf-PE distribution with parameters \eqn{\alpha} and \eqn{\beta}. The support of the Zipf-PE
distribution are the strictly positive integer numbers large or equal than one.
}
\details{
The \emph{probability mass function} of the Zipf-PE distribution with parameters \eqn{\alpha} and \eqn{\beta}
at a positive integer value \eqn{x} is computed as follows:

\deqn{p(x | \alpha, \beta) = \frac{e^{\beta (1 - \frac{\zeta(\alpha, x)}{\zeta(\alpha)})} (e^{\beta \frac{x^{-\alpha}}{\zeta(\alpha)}} - 1)}
{e^{\beta} - 1},\, x= 1,2,...,\, \alpha > 1,\, -\infty < \beta < +\infty,}

where \eqn{\zeta(\alpha)} is the Riemann-zeta function at \eqn{\alpha}, and \eqn{\zeta(\alpha, x)}
is the Hurtwitz zeta function with arguments \eqn{\alpha} and x.

The \emph{cumulative distribution function} at a given positive
integer value \eqn{x}, \eqn{F(x)}, is equal to:
\deqn{F(x) = \frac{e^{\beta (1 - \frac{\zeta(\alpha, x + 1)}{\zeta(\alpha)})} - 1}{e^{\beta} -1}}

The quantile of the Zipf-PE\eqn{(\alpha, \beta)} distribution of a given probability value p
is equal to the quantile of the Zipf\eqn{(\alpha)} distribution at the value:

\deqn{p\prime = \frac{log(p\, (e^{\beta} - 1) + 1)}{\beta}}
The quantiles of the Zipf\eqn{(\alpha)} distribution are computed by means of the \emph{tolerance}
package.

To generate random data from a Zipf-PE one applies the \emph{quantile} function over \emph{n} values randomly generated
from an Uniform distribution in the interval (0, 1).
}
\examples{
dzipfpe(1:10, 2.5, -1.5)
pzipfpe(1:10, 2.5, -1.5)
qzipfpe(0.56, 2.5, 1.3)
rzipfpe(10, 2.5, 1.3)

}
\references{
{
Young, D. S. (2010). \emph{Tolerance: an R package for estimating tolerance intervals}. Journal of Statistical Software, 36(5), 1-39.
}
}
