% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmmviterbi.R
\name{hsmmviterbi}
\alias{hsmmviterbi}
\title{Viterbi algorithm to decode the latent states for hidden semi-Markov models}
\usage{
hsmmviterbi(y, ntimes = NULL, M, trunc, prior, dt_dist, dt_parm, tpm_parm,
  emit_parm, zero_init, plot = TRUE, xlim = NULL, ylim = NULL, ...)
}
\arguments{
\item{y}{the observed series to be decoded}

\item{ntimes}{vector specifying the lengths of individual, 
i.e. independent, time series. If not specified, the responses are assumed to 
form a single time series, i.e. ntimes=length(y)}

\item{M}{number of latent states}

\item{trunc}{a vector specifying truncation at the maximum number of dwelling time in 
each state. The higher the truncation, the more accurate the approximation but also 
the more computationally expensive.}

\item{prior}{a vector of prior probability values}

\item{dt_dist}{dwell time distribution, can only be "log", "geometric",
or "shiftedpoisson"}

\item{dt_parm}{a vector of parameter values in each dwell time distribution, which 
should be a vector of p's for dt_dist == "log" and a vector of theta's for 
dt_dist=="shiftpoisson"}

\item{tpm_parm}{transition probability matrix}

\item{emit_parm}{a vector containing means for each poisson distribution}

\item{zero_init}{a vector containing structural zero proportions in each state}

\item{plot}{whether a plot should be returned}

\item{xlim}{vector specifying the minimum and maximum on the x-axis in the plot. 
Default to NULL.}

\item{ylim}{vector specifying the minimum and maximum on the y-axis in the plot. 
Default to NULL.}

\item{...}{further arguments to be passed to the plot() function}
}
\value{
the decoded series of latent states
}
\description{
Viterbi algorithm to decode the latent states for hidden semi-Markov models
}
\examples{
#3 zero-inflated poissons

prior_init <- c(0.3,0.3,0.4)
dt_init <- c(10,8,6)
emit_init <- c(10,50,100)
zeroprop <- c(0.5,0.3,0.2)
trunc <- c(10,10,10)
omega <- matrix(c(0,0.3,0.7,0.4,0,0.6,0.5,0.5,0),3,3,byrow=TRUE)
result <- hsmmsim(n=1000,M=3,prior=prior_init,dt_dist="shiftpoisson",
         dt_parm=dt_init, tpm_parm=omega,emit_parm=emit_init,zeroprop=zeroprop)
y <- result$series
state <- result$state
fit <- hsmmfit(y=y,ntimes=NULL,M=3,trunc=trunc,prior_init=prior_init,dt_dist="shiftpoisson",
     dt_init=dt_init,tpm_init=omega,emit_init=emit_init,zero_init=zeroprop,
     method="BFGS",hessian=FALSE,control=list(maxit=500,trace=1))
decode <- hsmmviterbi(y=y,ntimes=NULL,M=3,trunc=trunc,prior=fit$prior,dt_dist="shiftpoisson",
     dt_parm=fit$dt_parm,tpm_parm=fit$tpm,emit_parm=fit$emit_parm,
     zero_init=fit$zeroprop,plot=TRUE,xlim=c(0,1000),ylim=c(0,200))
#check the missclassification rate
sum(decode!=state)/length(state)
     
     
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}

