% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasthmmfit.cont.R
\name{fasthmmfit.cont}
\alias{fasthmmfit.cont}
\title{Fast gradient descent / stochastic gradient descent algorithm to learn the parameters
in a specialized continuous-time zero-inflated hidden Markov model, where 
zero-inflation only happens in State 1. And if there were covariates, they 
could only be the same ones for the state-dependent log Poisson means and 
the logit structural zero proportion.}
\usage{
fasthmmfit.cont(y, x = NULL, M, prior_init, tpm_init, emit_init, zero_init,
  yceil = NULL, timeindex, method = "Nelder-Mead", hessian = FALSE, ...)
}
\arguments{
\item{y}{observed time series values}

\item{x}{matrix of covariates for the log poisson means and logit zero proportion.
Default to NULL.}

\item{M}{number of latent states}

\item{prior_init}{a vector of initial values for prior probability for each state}

\item{tpm_init}{a matrix of initial values for transition rate matrix}

\item{emit_init}{a vector of initial values for the means for each poisson distribution}

\item{zero_init}{a scalar initial value for the structural zero proportion}

\item{yceil}{a scalar defining the ceiling of y, above which the values will be
truncated. Default to NULL.}

\item{timeindex}{a vector containing the time points}

\item{method}{method to be used for direct numeric optimization. See details in
the help page for optim() function. Default to Nelder-Mead.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Note that the hessian is for the working parameters, which are the generalized logit of prior 
probabilities (except for state 1), the generalized logit of the transition probability 
matrix(except 1st column), the logit of non-zero zero proportions, and the log of 
each state-dependent poisson means}

\item{...}{Further arguments passed on to the optimization methods}
}
\value{
the maximum likelihood estimates of the zero-inflated hidden Markov model
}
\description{
Fast gradient descent / stochastic gradient descent algorithm to learn the parameters
in a specialized continuous-time zero-inflated hidden Markov model, where 
zero-inflation only happens in State 1. And if there were covariates, they 
could only be the same ones for the state-dependent log Poisson means and 
the logit structural zero proportion.
}
\examples{
priorparm <- 0
tpmparm <- c(-1,-2)
zeroindex <- c(1,0)
zeroparm <- c(0,-1,1)
emitparm <- c(2,0.5,-0.5,3,0.3,-0.2)
workparm <- c(priorparm,tpmparm,zeroparm,emitparm)
timeindex <- rep(1,1000)
for(i in 2:1000) timeindex[i] <- timeindex[i-1] + sample(1:4,1)

designx <- matrix(rnorm(2000),nrow=1000,ncol=2)
x <- cbind(1,designx) #has to make the additional 1st column of 1 for intercept
result <- hmmsim2.cont(workparm,2,1000,zeroindex,emit_x=designx,
                      zeroinfl_x=designx,timeindex=timeindex)
y <- result$series
state <- result$state

fit2 <-  fasthmmfit.cont(y=y,x=designx,M=2,prior_init=c(0.5,0.5),
  tpm_init=matrix(c(-0.2,0.2,0.1,-0.1),2,2,byrow=TRUE),
  zero_init=0.4,emit_init=c(7,21), timeindex=timeindex,
  hessian=FALSE, method="BFGS", control=list(trace=1))
}
\references{
Liu, Yu-Ying, et al. "Efficient learning of continuous-time hidden 
markov models for disease progression." Advances in neural information 
processing systems. 2015.
}
