% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmsim.cont.R
\name{hmmsim.cont}
\alias{hmmsim.cont}
\title{Simulate a hidden Markov series and its underlying states
with zero-inflated emission distributions}
\usage{
hmmsim.cont(n, M, prior, tpm_parm, emit_parm, zeroprop, timeindex)
}
\arguments{
\item{n}{length of the simulated series}

\item{M}{number of hidden states}

\item{prior}{a vector of prior probability for each state}

\item{tpm_parm}{transition rate matrix}

\item{emit_parm}{a vector containing means for each poisson distribution}

\item{zeroprop}{a vector containing structural zero proportions in each state}

\item{timeindex}{a vector containing the time points}
}
\value{
simulated series and corresponding states
}
\description{
Simulate a hidden Markov series and its underlying states
with zero-inflated emission distributions
}
\examples{
prior_init <- c(0.5,0.2,0.3)
emit_init <- c(10,40,70)
zero_init <- c(0.5,0,0)
omega <- matrix(c(-0.3,0.2,0.1,0.1,-0.2,0.1,0.2,0.2,-0.4),3,3,byrow=TRUE)
timeindex <- rep(1,1000)
for(i in 2:1000) timeindex[i] <- timeindex[i-1] + sample(1:3,1)
result <- hmmsim.cont(n=1000,M=3,prior=prior_init, tpm_parm=omega,
          emit_parm=emit_init,zeroprop=zero_init,timeindex=timeindex)
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
