% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{create_compressor}
\alias{create_compressor}
\title{Create a new compressor object}
\usage{
create_compressor(
  level = -1L,
  method = 8L,
  wbits = 15L,
  memLevel = 8L,
  strategy = 0L,
  zdict = NULL
)
}
\arguments{
\item{level}{Compression level, integer between 0 and 9, or -1 for default.}

\item{method}{Compression method.}

\item{wbits}{Window size bits.}

\item{memLevel}{Memory level for internal compression state.}

\item{strategy}{Compression strategy.}

\item{zdict}{Optional predefined compression dictionary as a raw vector.}
}
\value{
A SEXP pointer to the new compressor object.
}
\description{
Initialize a new compressor object for zlib-based compression with specified settings.
}
\examples{
compressor <- create_compressor(level = 6, memLevel = 8)
}
