% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compress_chunk}
\alias{compress_chunk}
\title{Compress a Chunk of Data}
\usage{
compress_chunk(compressorPtr, input_chunk)
}
\arguments{
\item{compressorPtr}{An external pointer to an existing compressor object.
This object is usually initialized by calling a different function like \code{create_compressor()}.}

\item{input_chunk}{A raw vector containing the uncompressed data that needs to be compressed.}
}
\value{
A raw vector containing the compressed data.
}
\description{
Compresses a given chunk of raw binary data using a pre-existing compressor object.
}
\details{
This function is primarily designed for use with a compressor object created by \code{create_compressor()}.
It takes a chunk of raw data and compresses it, returning a raw vector of the compressed data.
}
\examples{
# Create a new compressor object for zlib -> wbts = 15
zlib_compressor <- create_compressor(wbits=31)
compressed_data <- compress_chunk(zlib_compressor, charToRaw("Hello, World"))
compressed_data <- c(compressed_data, flush_compressor_buffer(zlib_compressor))
decompressed_data <- memDecompress(compressed_data, type = "gzip")
cat(rawToChar(decompressed_data))
}
