% File validate.Rd

\name{print.genlist}

\alias{print.genlist}

\title{Print Basic Metrics for Each Zonohedron Generated by the Matrices in a \bold{genlist} object }

\description{
An S3 class \bold{genlist} object is organized as a named list
of 3xN matrices, when N varies.
The \code{print()} method constructs a zonohedron object from each matrix
and then prints some basic metrics about each zonohedron, as a data frame.
If the matrix has the \code{"fullname"} attribute, it is added as a column.
The names of the list are copied to the rownames of the data frame.
}

\usage{
\S3method{print}{genlist}( x, full=TRUE, ... )
}

\arguments{
\item{x}{a \code{genlist} object}

\item{full}{if \code{TRUE}, include \code{area} and \code{volume} columns}

\item{...}{not used}
}


\value{
The function returns \code{TRUE} or \code{FALSE}.
}   

\details{
\code{print.genlist()} uses \code{summary.zonohedron()}.
}

\seealso{
\code{\link{genlist}},
\code{\link{summary.zonohedron}()}
}

\examples{
# print zonohedra metrics associated with 3 sets of color matching functions
colorimetry.genlist
#                    fullname generators vertices  edges facets      area     volume
# xyz1931.5nm xyz at 5nm step         81     5100  10146   5048  1582.722   4070.345
# xyz1931.1nm xyz at 1nm step        471   112910 225720 112812 39586.707 509434.149
# lms2000.1nm lms at 1nm step        441   146642 292860 146220 22736.652 181369.085


names(classics.genlist)
#  [1] "C"   "RD"  "BD"  "RI"  "RHD" "RT"  "TO"  "TRD" "TC"  "RE"  "RH"  "TI"  "TSR"

print( classics.genlist, full=FALSE )
#                                   fullname generators vertices edges facets
# C                                     cube          3        8    12      6
# RD                    rhombic dodecahedron          4       14    24     12
# BD                   Bilinski dodecahedron          4       14    24     12
# RI                     rhombic icosahedron          5       22    40     20
# RHD          rhombo-hexagonal dodecahedron          5       18    28     12
# RT                 rhombic triacontahedron          6       32    60     30
# TO                    truncated octahedron          6       24    36     14
# TRD         truncated rhombic dodecahedron          7       32    48     18
# TC                 truncated cuboctahedron          9       48    72     26
# RE                rhombic enneacontahedron         10       92   180     90
# RH              rhombic hectotriadiohedron         12      134   264    132
# TI             truncated icosidodecahedron         15      120   180     62
# TSR truncated small rhombicosidodecahedron         21      240   360    122
}

