% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.default}
\alias{normalize.zoo}
\title{Normalize data}
\usage{
normalize(x, ...)

\method{normalize}{default}(x, method = "sd1", base.period = 1:nrow(x), ...)

\method{normalize}{zoo}(x, method = "sd1", base.period = index(x), ...)
}
\arguments{
\item{x}{a vector, matrix, data frame or \code{zoo} object.}

\item{...}{additional arguments to be passed to or from methods.}

\item{method}{a character string indicating which method to use. 
Must be 'sd1'(default), 'anomaly' or 'perc'. See details.}

\item{base.period}{a vector indicating the index or range of the base period.
If NULL, base period is the all index range. For matrix, base.period means
the row numbers.}
}
\description{
Normalize each column of the object using different methods. See details.
}
\details{
Three methods for normalization can be used:
\enumerate{
\item "anomaly": Each column is normalized by \eqn{x - \mu}, 
where \eqn{\mu} is the mean value based on the \code{base.period}.
\item "perc": Each column is normalized by \eqn{100 (x - \mu) / \mu}.
This is often called anomaly percentage.
\item "sd1": Each column is normalized by \eqn{(x - \mu) / \sigma}, 
where \eqn{\sigma} is the standard deviation based on the \code{base.period}.
The standard deviations of the results will be 1 if the \code{base.period} 
is set to be the whole time range.  
}
}
\examples{

x <- matrix(1 : 20, nrow = 10)
colnames(x) <- c('a', 'b')
rownames(x) <- 1 : 10
normalize(x, method = 'anomaly')
normalize(x, method = 'perc')
normalize(x, method = 'sd1')

z <- zoo(x, order.by = 1991 : 2010)
normalize(z)

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
normalize(zc)

}

