# Automatically generated from all.nw using noweb
# Methods for survfitms objects
summary.survfit <- function(object, times, censored=FALSE, 
                            scale=1, extend=FALSE, 
                            rmean=getOption('survfit.rmean'),
                            ...) {
    fit <- object
    if (!inherits(fit, 'survfit'))
            stop("summary.survfit can only be used for survfit objects")

    # The print.rmean option is depreciated, still paid
    #   attention to in print.survfit, but ignored here
    if (is.null(rmean)) rmean <- "none"

    temp <- survmean(fit, scale=scale, rmean)  
    table <- temp$matrix  #for inclusion in the output list
    rmean.endtime <- temp$end.time

    # The fit$surv object is sometimes a vector and sometimes a
    #  matrix.  We calculate row indices first, and then deal
    #  with the cases at the end.
    nsurv <- if (is.matrix(fit$surv)) nrow(fit$surv) else length(fit$surv)
    if (is.null(fit$strata)) {
        nstrat <- 1
        stemp <- rep(1L, nsurv)
        strata.names <- ""
        }
    else   {
        nstrat <- length(fit$strata)
        stemp <- rep(1:nstrat, fit$strata)
        strata.names <- names(fit$strata)
    }

    if (missing(times)) {
        # just pick off the appropriate rows of the output
        if (censored) indx1 <- seq(along=fit$time)
        else indx1 <- which(fit$n.event>0)
    }
    else {  
        # The one line function below might be opaque (even to me) --
        # For n.event, we want to know the number since the last chosen
        #  printout time point.  Start with the curve of cumulative
        #  events at c(0, stime) (the input time points), which is
        #  the cumsum below; pluck off the values corresponding to our
        #  time points, the [x] below; then get the difference since the
        #  last chosen time point (or from 0, for the first chosen point).
        cfun <- function(x, data) diff(c(0, cumsum(c(0,data))[x]))


        # Process the curves one at a time,
        #   adding the results for that curve onto a list, so the
        #   number of events will be n.enter[[1]], n.enter[[2]], etc.
        # For the survival, stderr, and confidence limits it suffices
        #   to create a single list 'indx1' containing a subscripting vector
        indx1 <- n.risk <- n.event <- newtimes <- vector('list', nstrat)
        n.enter <- vector('list', nstrat)
        n.censor<- vector('list', nstrat)
        n <- length(stemp)
        for (i in 1:nstrat) {
            who <- (1:n)[stemp==i]  # the rows of the object for this strata
            stime <- fit$time[who]

            # First, toss any printing times that are outside our range
            if (is.null(fit$start.time)) mintime <- min(stime, 0)
            else                         mintime <- fit$start.time
            ptimes <- times[times >= mintime]

            if (!extend) {
                maxtime <- max(stime)
                ptimes <- ptimes[ptimes <= maxtime]
                }

            newtimes[[i]] <- ptimes

            # If we tack a -1 onto the front of the vector of survival
            #  times, then indx1 is the subscript for that vector
            #  corresponding to the list of "ptimes".  If the input
            #  data had stime=c(10,20) and ptimes was c(5,10,15,20),
            #  the result would be 1,2,2,3.
            # For n.risk we want a slightly different index: 2,2,3,3.
            #  "In between" times point to the next higher index for n.risk,
            #  but the next lower one for survival. (Survival drops at time t,
            #  the n.risk immediately afterwords at time t+0: you were at
            #  risk just before you die, but not a moment after). The
            #  extra point needs to be added at the end.
            #
            ntime <- length(stime)  #number of points
            temp1 <- approx(c(mintime-1, stime), 0:ntime, xout=ptimes,
                            method='constant', f=0, rule=2)$y
            indx1[[i]] <- ifelse(temp1==0, 1, 1+ who[pmax(1,temp1)])
            # Why not just "who[temp1]" instead of who[pmax(1,temp1)] in the
            #  line just above?  When temp1 has zeros, the first expression
            #  gives a vector that is shorter than temp1, and the ifelse
            #  doesn't work right due to mismatched lengths.  
            n.event[[i]] <- cfun(temp1+1, fit$n.event[who])

            if (!is.null(fit$n.censor)) {
                    n.censor[[i]] <- cfun(temp1+1, fit$n.censor[who])
                    j <- who[ntime]  #last time point in the data
                    last.n <- fit$n.risk[j] - (fit$n.event[j]+ fit$n.censor[j])
                    }
            else {
                # this is for the older survfit objects, which don't contain
                #  n.censor.  In this case, we don't know how many of the
                #  people at the last time are censored then & how many go
                #  on further.  Assume we lose them all.  Note normally
                #  extend=FALSE, so this number isn't printed anyway.
                last.n <- 0
                }

            # Compute the number at risk.  If stime = 1,10, 20 and ptime=3,10,
            #   12, then temp1 = 2,2,3: the nrisk looking ahead
            # approx() doesn't work if stime is of length 1
            if (ntime ==1) temp1 <- rep(1, length(ptimes))
            else temp1 <- approx(stime, 1:ntime, xout=ptimes,
                            method='constant', f=1, rule=2)$y
            n.risk[[i]] <- ifelse(ptimes>max(stime), last.n,
                                  fit$n.risk[who[temp1]])
         }
            
        times  <- unlist(newtimes)
        n.risk <-  unlist(n.risk)
        n.event <- unlist(n.event)
        n.enter <- unlist(n.enter)   #may be NULL
        n.censor<- unlist(n.censor)  #may be NULL
        
        indx1 <- unlist(indx1)
    }

    # Create an output structure
    if (length(indx1)==length(fit$time) && all(indx1 == seq(along=fit$time))) {
        temp <- object  #no change
        temp$time <- temp$time/scale
        temp$table <- table
        if (!is.null(temp$strata))
            temp$strata <- factor(stemp, labels=strata.names)

    }
    else if (missing(times)) {  #default censor=FALSE case
        temp <- object
        temp$time <- temp$time[indx1]/scale
        temp$table <- table
        for (j in c("n.risk", "n.event", "n.censor", "n.enter",
                    "surv", "std.err", "lower", "upper")) {
            zed <- temp[[j]]
            if (!is.null(zed)) {
                if (is.matrix(zed)) temp[[j]] <- zed[indx1,,drop=FALSE]
                else temp[[j]] <- zed[indx1]
            }
        }
        if (!is.null(temp$strata))
            temp$strata <- factor(stemp[indx1], levels=1:nstrat,
                                  labels=strata.names)
    }
    else { #times argument was given
        temp <- list(n=object$n, time=times/scale, 
                     n.risk=n.risk, n.event=n.event,
                     conf.int=fit$conf.int, type=fit$type, table=table)
        if (!is.null(n.censor)) temp$n.censor <- n.censor
        if (!is.null(n.enter))  temp$n.enter <- n.enter
        if (!is.null(fit$start.time)) temp$start.time <- fit$start.time
            
        # why the rbind?  The user may have specified a time point before
        #  the first event, and indx1=1 indicates that case
        if (is.matrix(fit$surv)) {
            temp$surv <- rbind(1, fit$surv)[indx1,,drop=FALSE]
            if (!is.null(fit$std.err))
                temp$std.err <- rbind(0, fit$std.err)[indx1,,drop=FALSE]
            if (!is.null(fit$lower)) {
                temp$lower <- rbind(1, fit$lower)[indx1,,drop=FALSE]
                temp$upper <- rbind(1, fit$upper)[indx1,,drop=FALSE]
            }
        }
        else {
            temp$surv <- c(1, fit$surv)[indx1]
            if (!is.null(fit$std.err)) temp$std.err <- c(0,fit$std.err)[indx1]
            if (!is.null(fit$lower)) {
                temp$lower <- c(1, fit$lower)[indx1]
                temp$upper <- c(1, fit$upper)[indx1]
            }
        }
        if (!is.null(fit$strata)) {
            scount <- unlist(lapply(newtimes, length))
            temp$strata <- factor(rep(1:nstrat, scount), levels=1:nstrat,
                                  labels=strata.names)
        }
    
        if (length(rmean.endtime)>0  && !is.na(rmean.endtime)) 
            temp$rmean.endtime <- rmean.endtime

        temp$call <- fit$call
        if (!is.null(fit$na.action)) temp$na.action <- fit$na.action
  
    }
    if (!is.null(temp$std.err))
        temp$std.err <- temp$std.err*temp$surv  #std error of the survival curve
    class(temp) <- 'summary.survfit'
    temp
}
summary.survfitms <- function(object, times, censored=FALSE, 
                            scale=1, extend=FALSE, 
                            rmean=getOption('survfit.rmean'),
                            ...) {
    fit <- object
    if (!inherits(fit, 'survfitms'))
            stop("summary.survfitms can only be used for survfitms objects")

    if (is.null(rmean)) rmean <- "none"

    # add some temps to make survmean work
    object$surv <- 1-object$prev
    if (is.matrix(object$surv)) 
        dimnames(object$surv) <- list(NULL, object$states)
    temp <- survmean(object, scale=scale, rmean)  
    table <- temp$matrix  #for inclusion in the output list
    rmean.endtime <- temp$end.time

    # The fit$prev object is usually a matrix but can be a vector
    #  We calculate row indices first, and then deal
    #  with the cases at the end.
    nprev <- if (is.matrix(fit$prev)) nrow(fit$prev) else length(fit$prev)
    if (is.null(fit$strata)) {
        nstrat <- 1
        stemp <- rep(1L, nprev)
        strata.names <- ""
        }
    else   {
        nstrat <- length(fit$strata)
        stemp <- rep(1:nstrat, fit$strata)
        strata.names <- names(fit$strata)
    }

    if (missing(times)) {
        # just pick off the appropriate rows of the output
        if (censored) indx1 <- seq(along=fit$time)
        else indx1 <- which(fit$n.event>0)
    }
    else {  
        # The one line function below might be opaque (even to me) --
        # For n.event, we want to know the number since the last chosen
        #  printout time point.  Start with the curve of cumulative
        #  events at c(0, stime) (the input time points), which is
        #  the cumsum below; pluck off the values corresponding to our
        #  time points, the [x] below; then get the difference since the
        #  last chosen time point (or from 0, for the first chosen point).
        cfun <- function(x, data) diff(c(0, cumsum(c(0,data))[x]))


        # Process the curves one at a time,
        #   adding the results for that curve onto a list, so the
        #   number of events will be n.enter[[1]], n.enter[[2]], etc.
        # For the survival, stderr, and confidence limits it suffices
        #   to create a single list 'indx1' containing a subscripting vector
        indx1 <- n.risk <- n.event <- newtimes <- vector('list', nstrat)
        n.enter <- vector('list', nstrat)
        n.censor<- vector('list', nstrat)
        n <- length(stemp)
        for (i in 1:nstrat) {
            who <- (1:n)[stemp==i]  # the rows of the object for this strata
            stime <- fit$time[who]

            # First, toss any printing times that are outside our range
            if (is.null(fit$start.time)) mintime <- min(stime, 0)
            else                         mintime <- fit$start.time
            ptimes <- times[times >= mintime]

            if (!extend) {
                maxtime <- max(stime)
                ptimes <- ptimes[ptimes <= maxtime]
                }

            newtimes[[i]] <- ptimes

            # If we tack a -1 onto the front of the vector of survival
            #  times, then indx1 is the subscript for that vector
            #  corresponding to the list of "ptimes".  If the input
            #  data had stime=c(10,20) and ptimes was c(5,10,15,20),
            #  the result would be 1,2,2,3.
            # For n.risk we want a slightly different index: 2,2,3,3.
            #  "In between" times point to the next higher index for n.risk,
            #  but the next lower one for survival. (Survival drops at time t,
            #  the n.risk immediately afterwords at time t+0: you were at
            #  risk just before you die, but not a moment after). The
            #  extra point needs to be added at the end.
            #
            ntime <- length(stime)  #number of points
            temp1 <- approx(c(mintime-1, stime), 0:ntime, xout=ptimes,
                            method='constant', f=0, rule=2)$y
            indx1[[i]] <- ifelse(temp1==0, 1, 1+ who[pmax(1,temp1)])
            # Why not just "who[temp1]" instead of who[pmax(1,temp1)] in the
            #  line just above?  When temp1 has zeros, the first expression
            #  gives a vector that is shorter than temp1, and the ifelse
            #  doesn't work right due to mismatched lengths.  
            n.event[[i]] <- cfun(temp1+1, fit$n.event[who])

            if (!is.null(fit$n.censor)) {
                    n.censor[[i]] <- cfun(temp1+1, fit$n.censor[who])
                    j <- who[ntime]  #last time point in the data
                    last.n <- fit$n.risk[j] - (fit$n.event[j]+ fit$n.censor[j])
                    }
            else {
                # this is for the older survfit objects, which don't contain
                #  n.censor.  In this case, we don't know how many of the
                #  people at the last time are censored then & how many go
                #  on further.  Assume we lose them all.  Note normally
                #  extend=FALSE, so this number isn't printed anyway.
                last.n <- 0
                }

            # Compute the number at risk.  If stime = 1,10, 20 and ptime=3,10,
            #   12, then temp1 = 2,2,3: the nrisk looking ahead
            # approx() doesn't work if stime is of length 1
            if (ntime ==1) temp1 <- rep(1, length(ptimes))
            else temp1 <- approx(stime, 1:ntime, xout=ptimes,
                            method='constant', f=1, rule=2)$y
            n.risk[[i]] <- ifelse(ptimes>max(stime), last.n,
                                  fit$n.risk[who[temp1]])
         }
            
        times  <- unlist(newtimes)
        n.risk <-  unlist(n.risk)
        n.event <- unlist(n.event)
        n.enter <- unlist(n.enter)   #may be NULL
        n.censor<- unlist(n.censor)  #may be NULL
        
        indx1 <- unlist(indx1)
    }

    # Create an output structure
    if (length(indx1)== length(fit$time) && all(indx1 == seq(along=fit$time))) {
        temp <- object  #no change
        temp$time <- temp$time/scale
        temp$table <- table
        if (!is.null(temp$strata)) 
            temp$strata <- factor(stemp, levels=1:nstrat, labels=strata.names)
    }
    else if (missing(times)) {
        temp <- object
        temp$time <- temp$time[indx1]/scale
        temp$table <- table
        for (j in c("n.risk", "n.event", "n.censor", "n.enter",
                    "prev", "std.err", "lower", "upper")) {
            zed <- temp[[j]]
            if (!is.null(zed)) {
                if (is.matrix(zed)) temp[[j]] <- zed[indx1,,drop=FALSE]
                else temp[[j]] <- zed[indx1]
            }
        }
        temp$cumhaz <- fit$cumhaz[,,indx1,drop=FALSE]
        if (!is.null(temp$strata))
            temp$strata <- factor(stemp[indx1], levels=1:nstrat,
                                  labels=strata.names)
    }
    else {
        temp <- list(n=object$n, time=times/scale, 
                     n.risk=n.risk, n.event=n.event,
                     conf.int=fit$conf.int, type=fit$type, table=table)
        if (!is.null(n.censor)) temp$n.censor <- n.censor
        if (!is.null(n.enter))  temp$n.enter <- n.enter
        if (!is.null(fit$start.time)) temp$start.time <- fit$start.time

        # why the rbind?  The user may have specified a time point before
        #  the first event, and indx1=1 indicates that case
        # the cumhaz array can't be done with a 1-liner
        if (is.matrix(fit$prev)) {
            temp$prev <- rbind(0, fit$prev)[indx1,,drop=FALSE]
            zz <- ifelse(indx1==1, NA, indx1-1)
            temp$cumhaz <- fit$cumhaz(,,zz, drop=FALSE)
            temp$cumhaz <- ifelse(is.na(temp$cumhaz), 0, temp$cumhaz)
            if (!is.null(fit$std.err)) 
                temp$std.err <- rbind(0, fit$std.err)[indx1,,drop=FALSE]
            if (!is.null(fit$lower)) {
                temp$lower <- rbind(0, fit$lower)[indx1,,drop=FALSE]
                temp$upper <- rbind(0, fit$upper)[indx1,,drop=FALSE]
            }
        }
        else {
            temp$prev <- c(0, fit$prev[indx1])
            temp$cumhaz <- c(0, fit$cumhaz[indx1])
            if (!is.null(fit$std.err)) temp$std.err <- c(0, fit$std.err)[indx1]
            if (!is.null(fit$lower)) {
                temp$lower <- c(0, fit$lower)[indx1]
                temp$upper <- c(0, fit$upper)[indx1]
            }
        }
        if (!is.null(fit$strata)) {
            scount <- unlist(lapply(newtimes, length))
            temp$strata <- factor(rep(1:nstrat, scount), levels=1:nstrat,
                                  labels=strata.names)
        }

        temp$call <- fit$call
        if (!is.null(fit$na.action)) temp$na.action <- fit$na.action
  
    }
        
    if (length(rmean.endtime)>0  && !is.na(rmean.endtime)) 
            temp$rmean.endtime <- rmean.endtime
    class(temp) <- "summary.survfitms"
    temp
}
"[.survfitms" <- function(x, ..., drop=TRUE) {
    nmatch <- function(indx, target) {
        temp <- 1:length(target)
        names(temp) <- target
        temp[indx]
    }
        
    if (missing(..1)) i<- NULL  else i <- sort(..1)
    if (missing(..2)) j<- NULL  else j <- ..2
    if (is.null(x$strata)) {
        if (is.matrix(x$prev)) {
            # No strata, but a matrix of prevalence values
            #  In this case, allow them to use a single i subscript as well
            if (is.null(j) && !is.null(i)) j <- i
            indx <- nmatch(j, x$states)
            if (any(is.na(indx)))
                stop("unmatched subscript", j[is.na(indx)])
            else j <- as.vector(indx)
            x$states <- x$states[j]
            
            if (nrow(x$prev)==1 && length(j) > 1) drop<- FALSE
            x$prev <- x$prev[,j,drop=drop]
            x$cumhaz <- x$cumhaz[j,j,, drop=drop]
            if (!is.null(x$std.err)) x$std.err <- x$std.err[,j,drop=drop]
            if (!is.null(x$upper)) x$upper <- x$upper[,j,drop=drop]
            if (!is.null(x$lower)) x$lower <- x$lower[,j,drop=drop]
            }
        else warning("Survfit object has only a single survival curve")
        }
    else {
        if (is.null(i)) keep <- seq(along.with=x$time) # rows to keep
        else {
            indx <- nmatch(i, names(x$strata)) #strata to keep
            if (any(is.na(indx))) 
                stop(paste("strata", 
                               paste(i[is.na(indx)], collapse=' '),
                               'not matched'))
            strat <- rep(names(x$strata), x$strata)
            keep <- seq(along.with=strat)[strat %in% names(indx)]
            if (length(indx) <=1) x$strata <- NULL
            else                  x$strata  <- x$strata[indx]

            x$n       <- x$n[indx]
            x$time    <- x$time[keep]
            x$n.risk  <- x$n.risk[keep]
            x$n.event <- x$n.event[keep]
            x$n.censor<- x$n.censor[keep]
            }
        if (is.matrix(x$prev)) { 
            # If [i,] selected only 1 row, don't collapse the columns
            if (length(keep) <2 && (is.null(j) || length(j) >1)) drop <- FALSE
            if (is.null(j)) {  #only subscript rows (strata)
                x$prev <- x$prev[keep,,drop=drop]
                x$cumhaz <- x$cumhaz[,,keep, drop=drop]
                if (!is.null(x$std.err)) 
                        x$std.err <- x$std.err[keep,,drop=drop]
                if (!is.null(x$upper)) x$upper <-x$upper[keep,,drop=drop]
                if (!is.null(x$lower)) x$lower <-x$lower[keep,,drop=drop]
                }
            else { #subscript both rows (strata) and columns (states)
                indx <- nmatch(j, x$states)
                if (any(is.na(indx))) 
                    stop("unmatched subscript", j[indx])
                else j <- as.vector(indx)
                x$states <- x$states[j]
                x$prev <- x$prev[keep,j, drop=drop]
                x$cumhaz <- x$cumhaz[j,j,keep, drop=drop]
                if (!is.null(x$std.err)) x$std.err <- x$std.err[keep,j,drop=drop]
                if (!is.null(x$upper)) x$upper <- x$upper[keep,j, drop=drop]
                if (!is.null(x$lower)) x$lower <- x$lower[keep,j, drop=drop]
                }
            }
        else {
            x$prev <- x$prev[keep]
            x$cumhaz <- x$cumhaz[keep]
            if (!is.null(x$std.err)) x$std.err <- x$std.err[keep]
            if (!is.null(x$upper)) x$upper <- x$upper[keep]
            if (!is.null(x$lower)) x$lower <- x$lower[keep]
            }
        }
    x
    }

