% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_beta_data.R
\name{delta_beta_data}
\alias{delta_beta_data}
\title{Applying delta beta analysis to calculate the difference between cases and controls}
\usage{
delta_beta_data(x, cases_column_1, cases_column_n, controls_column_1,
  controls_column_n, meth_cutoff, unmeth_cutoff, high_meth, low_meth)
}
\arguments{
\item{x}{the filtered 450k probes from filter_data function}

\item{cases_column_1}{The first column (column number) for cases in the filtered dataset}

\item{cases_column_n}{The last column (column number) for cases in the filtered dataset}

\item{controls_column_1}{The first column (column number) for controls in the filtered dataset}

\item{controls_column_n}{The last column (column number) for controls in the filtered dataset}

\item{meth_cutoff}{The cutoff level for the methylation difference between cases and controls (cases minus controls)}

\item{unmeth_cutoff}{The cutoff level for the methylation difference between controls and cases (cases minus controls). Consequently, it requires a negative value.}

\item{high_meth}{The upper margin for the highly methylated probes}

\item{low_meth}{The lower margin for the low methylation}
}
\description{
This function calculates the delta beta value for the filtered probes. It calculates the difference in mean DNA methylation between cases and controls for each probe. Also, it selects probes with DNA methylation differences that are higher in cases than controls by a user specified meth_cutoff value and differences that are lower in cases than controls by the unmeth_cutoff value. In addition, the function provides the option to specify probes where the average beta value of the cases or controls is greater than a high_meth cutoff value or less than a low_meth cutoff value.
}
\examples{
data(test_data)
data(nonspecific_probes)
test_data_filtered <- filter_data(test_data)
test_data_delta_beta <- delta_beta_data(test_data_filtered, 1, 2, 3, 4, 0.5, -0.5, 0.94, 0.06)

}

