% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_candidate_genes.R
\name{plot_candidate_genes}
\alias{plot_candidate_genes}
\title{Plotting highly different and significant probes annotated by their corresponding gene names}
\usage{
plot_candidate_genes(x)
}
\arguments{
\item{x}{Results from the overlap_data function}
}
\description{
This function plots the potential candidate genes for which multiple CpG sites show significant difference.
}
\examples{
\donttest{
data(test_data)
data(nonspecific_probes)
data(annotation_file)
test_data_filtered <- filter_data(test_data)
test_data_ttest <- ttest_data(test_data_filtered, 1, 2, 3, 4, 1e-3)
test_data_delta_beta <- delta_beta_data(test_data_filtered, 1, 2, 3, 4, 0.5, -0.5, 0.94, 0.06)
test_overlapped_data <- overlap_data(test_data_ttest, test_data_delta_beta)
plot_candidate_genes(test_overlapped_data)
}
}

