% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACE.R
\name{ACE}
\alias{ACE}
\title{Analysis of Correlated High-Dimensional Expression (ACE) Data}
\usage{
ACE(Z, X, H0_indicator, gama)
}
\arguments{
\item{Z}{The observed data matrix with the variables in rows and samples in columns. It is a \eqn{p}-by-\eqn{n_1} matrix.}

\item{X}{(Optional) The observed data matrix with the variables in rows and samples in columns. It is a \eqn{p}-by-\eqn{n_2} matrix.
If X is present, then perform the two-sample test; otherwise, perform one-sample test.}

\item{H0_indicator}{(Optional) A \eqn{p}-dimensional vector containing only 0 and 1.
A value of 1 means the variable/gene is non-null and a value of 0 means the gene is null.}

\item{gama}{FDR control level.}
}
\value{
An object with S3 class \code{ACE} containing the following items will be returned:
\describe{
\item{\code{FDP}}{If H0_indicator exists, FDP is true FDP, otherwise, it is estimated FDP.}
\item{\code{Power}}{If H0_indicator exists, power is output which is defined as the ratio of the number of correctly rejected to the number of non-nulls.}
\item{\code{Rejection}}{The number of rejections.}
\item{\code{Adjusted_mean_difference}}{Factor-adjusted mean difference which is a \eqn{p}-dimensional vector.}
\item{\code{Adjusted_statistics}}{Factor-adjusted statistics (\eqn{p}-dimensional vector).}
\item{\code{Threshold}}{A critical value. When absolute factor-adjusted statistics is larger than the threshold, we reject it.}
\item{\code{Estimated_number_factor}}{The estimated number of factors.}
\item{\code{pai1_hat}}{The estimated proportion of non-nulls.}
}
}
\description{
A function for estimating factor models, giving factor-adjusted statistics.
}
\examples{
library(mvtnorm); library(quantreg)
p <- 200; n <- 100; h <- 3 # the number of variables, samples and factors
berlii <- rbinom(p, 1, 0.2) # 1 means the variable is non-null and 0 means it is null.
index0 <- which(berlii == 0); index1 <- which(berlii == 1)

mu <- matrix(rep(0, 1*p), nrow=p)
mu[index1] <- runif(length(index1), min=0.4, max=0.7) # expectation of data
B <- matrix(runif(h*p, min=-1, max=1), nrow=p) # factor loading matrix
t_error <- t(rmvt(n, sigma = diag(p), df = 10)) # error term followed t-distribution
f <- t(rmvt(n, diag(h), df = 4))/sqrt(4/(4-2)) # factor followed t-distribution
Y <- mu \%*\% matrix(rep(1, n*1), nrow=1) + B \%*\% f + t_error # data
res <- ACE(Z = Y, H0_indicator = berlii, gama = 0.05)
res$FDP # true FDP
res$Power # power

}
\references{
Cao, H., & Kosorok, M. R. (2011). Simultaneous critical values for t-tests in very high dimensions. Bernoulli, 17, 347.

Wang, P., Lyu, P., Peddada, S., Cao, H. (2023+). A powerful methodology for analyzing correlated high dimensional data using factor models. results not shown.
}
