% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EWMA.R
\name{EWMA}
\alias{EWMA}
\title{Exponentially Weighted Moving Average}
\usage{
EWMA(TL)
}
\arguments{
\item{TL}{training load}
}
\value{
{This function returns the following variables:
\itemize{
\item EWMA_chronic: EWMA - chronic training load.
\item EWMA_acute: EWMA - acute training load.
\item EWMA_ACWR: EWMA - Acute-Chronic Workload Ratio.
}}
}
\description{
Exponentially Weighted Moving Average
}
\examples{

\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Read db
data("training_load", package = "ACWR")

# Convert to data.frame
training_load <- data.frame(training_load)

# Select the first subject
training_load_1 <- training_load[training_load[["ID"]] == 1,  ]

# Calculate ACWR
result_EWMA <- EWMA(TL = training_load_1$TL)

# set user working directory
setwd(oldwd)
}

}
