% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boosting.R
\name{Boosting}
\alias{Boosting}
\title{Estimation of Functional Forms of Covaraites under AFT Models}
\usage{
Boosting(data, iter = 50)
}
\arguments{
\item{data}{A \code{c(n,p+2)} dimension of data, where \code{n} is sample size and
\code{p} is the number of covariates. The first column is survival time and second
column is censoring status, and the other columns are covariates.}

\item{iter}{The iteration times of the boosting procedure. The default value = 50 and the iteration will stop
when the absolute value of increment of every estimated value is small than 0.01.}
}
\value{
covariates The first ten covariates that are selected in the iteration.

functional_forms The functional forms of the first ten covariates that are selected
in the iteration.

predicted_failure_time The predicted failure time of every sample

survival_curve Predicted survival curve of the sample.
}
\description{
The function aims to select informative covariates under the AFT model and estimate their corresponding
functional forms with survival time. Specifically, the first step in this function is to derive an unbiased
estimating function by the Buckley-James method with corrected survival times and censoring status. After that, a
boosting algorithm with the cubic-spline method is implemented to an unbiased estimating function to detect
informative covariates and estimate the functional forms of covariates iteratively.
}
\examples{
## generate data with misclassification = 0.9 with n = 50, p = 6
## and variance of noise term is 0.75. The y* is is related to the first
## covariate.

b <- matrix(0,ncol=6, nrow = 1)
b[1,1] <- 1
data <- data_gen(n=50, p=6, pi_01=0.9, pi_10 = 0.9, gamma0=1,
gamma1=b, e_var=0.75)

## Assume that covariates are independent and observed failure time is
## related to first covariate with weight equals 1. And the scalar
## in the classical additive measurement error model is 1 and
## Misclassifcation probability = 0.9.

matrixb <- diag(6)
gamma_0 <-  1
gamma_1 <- matrix(0,ncol=6, nrow =1)
gamma_1[1,1] <- 1
data1 <- ME_correction(pi_10=0.9,pi_01=0.9,gamma0 = gamma_0,
gamma1 = gamma_1,
cor_covar=matrixb, y=data[,1],
indicator=data[,2], covariate = data[,3:8])
data1 <- cbind(data1,data[,3:8])

## Data in boosting procedure with iteration times =2

result <- Boosting(data=data1, iter=2)


}
