% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{design.plot}
\alias{design.plot}
\title{Design plot.}
\usage{
design.plot(design, xAxis, yAxis)
}
\arguments{
\item{design}{the data frame containing the coordinates and the number of
allocation of each design point. The design created by either
\code{\link{altopt.rc}} or \code{\link{altopt.ic}} or any design matrix
with the same form as those can be provided for this argument.}

\item{xAxis}{the name of the factor to be displayed in x axis.}

\item{yAxis}{the name of the factor to be displayed in y axis.}
}
\value{
The bubble plot of a design with two stress factors.
}
\description{
\code{\link{design.plot}} draws design plot as a form of a bubble plot
of any two stress factors which are specified by \code{xAxis} and \code{yAxis}.
The size of each bubble indicates the relative magnitude of allocation on
each design point.
}
\examples{
\dontrun{
# Design plot of D optimal design with right censoring.
Design1 <- altopt.rc("D", 100, 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01))

design.plot(Design1$opt.design.rounded, x1, x2)
}
}
