% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_suit.R
\name{overall_suit}
\alias{overall_suit}
\title{Overall Suitability Scores/Class of the Land Units}
\usage{
overall_suit(suit, method = NULL, interval = NULL)
}
\arguments{
\item{suit}{an object of class suitability.}

\item{method}{a character for the method for computing the overall suitability, choices are:
\code{"minimum"}, \code{"maximum"}, and
\code{"average"}. If \code{NULL}, method is set to \code{"minimum"}.}

\item{interval}{if \code{NULL}, the interval of the suitability class are the following: 0\% - 25\% (Not
suitable, N), 25\% - 50\% (Marginally Suitable, S3), 50\% - 75\% (Moderately Suitable, S2), and
75\% - 100\% (Highly Suitable, S1). But users can assign custom intervals by specifying
the values of the end points of the intervals. Say for intervals: 0\% - 20\% (Not
suitable, N), 20\% - 50\% (Marginally Suitable, S3), 50\% - 80\% (Moderately Suitable, S2), and
80\% - 100\% (Highly Suitable, S1), is equivalent to \code{interval = c(0, 0.2, 0.5, 0.8, 1)}.}
}
\value{
A data frame with columns:
\itemize{
 \item \code{Score} - the overall suitability scores
 \item \code{Class} - the overall suitability classes
}
}
\description{
This function computes the overall suitability scores and class of the land units.
}
\examples{
library(ALUES)
out <- suit("ricebr", terrain=MarinduqueLT, water=MarinduqueWater, temp=MarinduqueTemp, sow_month=1)
out[["terrain"]]

# Soil Overall Suitability
head(overall_suit(out[["soil"]]))
head(overall_suit(out[["soil"]], "average"))
head(overall_suit(out[["soil"]], "maximum"))
head(overall_suit(out[["soil"]], "average", c(0, 0.3, 0.35, 0.6, 1.0)))

# Water Overall Suitability
head(overall_suit(out[["water"]], "average"))
head(overall_suit(out[["water"]], "maximum"))
head(overall_suit(out[["water"]], "average", c(0, 0.3, 0.35, 0.6, 1.0)))

# Temperature Overall Suitability
head(overall_suit(out[["temp"]], "average"))
head(overall_suit(out[["temp"]], "maximum"))
head(overall_suit(out[["temp"]], "average", c(0, 0.3, 0.35, 0.6, 1.0)))
}
\seealso{
\code{\link{suit}}, \code{https://alstat.github.io/ALUES/}
}
