% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMCcreateelements.R
\name{AMCcreateelements}
\alias{AMCcreateelements}
\title{Generate AMC LaTeX question group ("element") codes}
\usage{
AMCcreateelements(element = "general", shufflequestions = TRUE,
  sections = TRUE, output = "message", filepath = "elements.tex",
  append = FALSE, messages = TRUE)
}
\arguments{
\item{element}{A character value or vector of question groups ("elements") to generate input code for. Default is "general".}

\item{shufflequestions}{A logical value or vector to indicate whether to shuffle questions inside a question group. Defaults to TRUE.}

\item{sections}{A character value or vector to indicate whether to create a new LaTeX section for each element (defaults to TRUE).}

\item{output}{A character value to indicate how to output the LaTeX commands. Use "message" (default) to get a console message that can be directly copy-and-pasted to the LaTeX mais file. Use "list" to get a list object. Use "file" to output to a .tex file (the path can be changed with the "filepath" command).
Defaults to "message}

\item{filepath}{A character value with the file path for the .tex file to be created (defaults to "elements.tex").}

\item{append}{A logical value indicating if the code should be appended (append=TRUE) to an existing .tex file. Defaults to FALSE, thus overwriting the file.}

\item{messages}{A logical to indicate whether instructions should be output (defaults to TRUE).}
}
\value{
Commands to add the question groups in AMC-LaTeX code.
}
\description{
Generate AMC LaTeX question group ("element") codes
}
\examples{
#To output a message (not visible in documentation)
AMCcreateelements(c(1:4))

#To output a list
AMCcreateelements(c(1:4), output = "list")

#Duplicates are automatically removed
AMCcreateelements(rep(1:3, 5), output = "list")

#To cancel shuffling
AMCcreateelements(c(1:4), output = "list", shufflequestions = FALSE)

#To remove sections at each element
AMCcreateelements(c(1:4), sections = FALSE, output = "list")

#To add sections for only last element
AMCcreateelements(c(1:4),
sections = c(FALSE,FALSE,FALSE,TRUE),
output = "list")
}
