% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApotcIndexing.R
\name{getLastApotcDataId}
\alias{getLastApotcDataId}
\alias{getLastApotcRunId}
\title{Get the object id of the most recent RunAPOTC run on a seurat object}
\usage{
getLastApotcDataId(seurat_obj)

getLastApotcRunId(seurat_obj)
}
\arguments{
\item{seurat_obj}{a seurat object that has had RunAPOTC ran on it before in
order of the functions being called.}
}
\value{
a character of the object id of the last \code{\link[=RunAPOTC]{RunAPOTC()}} call
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A convenience function to get the object id of the most recent valid
\code{\link[=RunAPOTC]{RunAPOTC()}} run, to be used by \code{\link[=APOTCPlot]{APOTCPlot()}} and \link{AdjustAPOTC}
}
\examples{
# first run
pbmc <- RunAPOTC(
    seurat_obj = get(data("combined_pbmc")),
    reduction_base = "umap",
    clonecall = "strict",
    verbose = FALSE
)

getLastApotcDataId(pbmc)
#> [1] "umap;CTstrict;_;_"

# second run with a different clonecall
pbmc <- RunAPOTC(
    seurat_obj = pbmc,
    reduction_base = "umap",
    clonecall = "gene",
    verbose = FALSE
)

getLastApotcDataId(pbmc)
#> [1] "umap;CTgene;_;_"

}
