% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_case}
\alias{parse_case}
\title{Case parser}
\usage{
parse_case(parsed_formula, case)
}
\arguments{
\item{parsed_formula}{A list containing the formula parts as returned from
\code{\link{parse_formula}}.}

\item{case}{An integer from 1-5 or a character string specifying whether the
'intercept' and/or the 'trend' have to participate in the short-run or the
long-run relationship (cointegrating equation) (see section 'Cases' below).}
}
\value{
An integer from 1-5 representing the case.
}
\description{
It parses the 'case' and checks the integrity of the 'case' input and the
compatibility with the formula.
}
\details{
Note that the statistical significance of 'ect' in a RECM should not be
tested using the corresponding t-statistic (or the p-value) because it
doesn't follow a standard t-distribution. Instead, the
\code{\link{bounds_t_test}} should be used.
}
\section{References}{
 Pesaran, M. H., Shin, Y., & Smith, R. J. (2001). Bounds
  testing approaches to the analysis of level relationships. \emph{Journal of
  Applied Econometrics}, 16(3), 289-326
}

\seealso{
\code{\link{parse_formula}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
