% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fit_lm}
\alias{fit_lm}
\title{fit_lm: Linear Regression Wrapper for the ARTtransfer package}
\usage{
fit_lm(X, y, X_val, y_val, X_test, min_prod = 1e-05, max_prod = 1 - 1e-05, ...)
}
\arguments{
\item{X}{A matrix of predictors for the training set.}

\item{y}{A vector of responses for the training set.}

\item{X_val}{A matrix of predictors for the validation set. If `NULL`, deviance is not calculated.}

\item{y_val}{A vector of responses for the validation set. If `NULL`, deviance is not calculated.}

\item{X_test}{A matrix of predictors for the test set. If `NULL`, predictions are not generated.}

\item{min_prod}{A numeric value indicating the minimum probability bound for predictions (not used in this function but passed for compatibility). Default is `1e-5`.}

\item{max_prod}{A numeric value indicating the maximum probability bound for predictions (not used in this function but passed for compatibility). Default is `1-1e-5`.}

\item{...}{Additional arguments passed to the function (currently unused).}
}
\value{
A list containing:
\item{dev}{The mean squared error (deviance) on the validation set if provided, otherwise `NULL`.}
\item{pred}{The predictions on the test set if `X_test` is provided, otherwise `NULL`.}
\item{coef}{The fitted coefficients of the linear model.}
}
\description{
This function fits a linear regression model using `lm()` and returns the 
coefficients, deviance on a validation set, and predictions on a test set. 
It is specifically designed for use in the `ART` adaptive and robust transfer learning framework.
}
\examples{
# Fit a linear model with validation and test data
X_train <- matrix(rnorm(100 * 5), 100, 5)
y_train <- X_train \%*\% rnorm(5) + rnorm(100)
X_val <- matrix(rnorm(50 * 5), 50, 5)
y_val <- X_val \%*\% rnorm(5) + rnorm(50)
X_test <- matrix(rnorm(20 * 5), 20, 5)

fit <- fit_lm(X_train, y_train, X_val, y_val, X_test)

}
