% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat13}
\alias{simDat13}
\title{Simulate data for Chapter 13: Poisson ANCOVA}
\usage{
simDat13(nPops = 3, nSample = 100, beta.vec = c(-2, 1, 2, 4, -2, -5))
}
\arguments{
\item{nPops}{Number of populations}

\item{nSample}{Number of samples per population}

\item{beta.vec}{Vector of regression coefficients}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nSample}{Number of samples per population}
  \item{beta}{Vector of regression coefficients}
  \item{x}{Indicator for population number}
  \item{pop}{Population name (factor)}
  \item{orig.length}{Wing length, non-centered}
  \item{wing.length}{Wing length, centered}
  \item{load}{Simulated parasite loads}
}
\description{
Simulate parasite load ~ size regressions in 3 populations of goldenring dragonflies
}
\examples{
str(dat <- simDat13())      # Implicit default arguments

# Revert to main-effects model with parallel lines on the log link scale
str(dat <- simDat13(nSample = 100, beta.vec = c(-2, 1, 2, 4, 0, 0)))

# Same with less strong regression coefficient
str(dat <- simDat13(nSample = 100, beta.vec = c(-2, 1, 2, 3, 0, 0)))

# Revert to simple linear Poisson regression: no effect of population (and less strong coefficient)
str(dat <- simDat13(nSample = 100, beta.vec = c(-2, 0, 0, 3, 0, 0)))

# Revert to one-way ANOVA Poisson model: no effect of wing length
# (Choose larger sample size and greater differences in the intercepts to better show patterns)
str(dat <- simDat13(nSample = 100, beta.vec = c(-1, 3, 5, 0, 0, 0)))

# Revert to Poisson "model-of-the-mean": no effects of either wing length or population
# Intercept chosen such that average parasite load is 10
str(dat <- simDat13(nSample = 100, beta.vec = c(log(10), 0, 0, 0, 0, 0)))
mean(dat$load)        # Average is about 10

}
\author{
Marc Kéry
}
