% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat18}
\alias{simDat18}
\title{Simulate data for Chapter 18: model selection}
\usage{
simDat18(
  nSites = 100,
  beta1.vec = c(1, 0.2, 0.5, 1, -1),
  ncov2 = 50,
  beta2.vec = rnorm(50, 0, 0),
  show.plot = TRUE
)
}
\arguments{
\item{nSites}{Sample size (number of snakes)}

\item{beta1.vec}{Values of log-linear intercept and coefs of rock, oak, 
and chip (linear and squared), in this order}

\item{ncov2}{Number of 'other' covariates}

\item{beta2.vec}{Values of coefs of the 'other' covariates (all continuous).
All at zero by default}

\item{show.plot}{Switch to turn on or off plotting. Set to 'FALSE' when running sims}
}
\value{
A list of simulated data and parameters.
  \item{nSites}{Sample size}
  \item{rock}{Rock covariate vector}
  \item{oak}{Oak covariate vector}
  \item{chip1}{Chip covariate vector}
  \item{chip2}{Chip^2 covariate vector}
  \item{Xrest}{Array of "other" covariate values}
  \item{beta1.vec}{Parameter values for intercept, rock, oak, chip, chip^2}
  \item{ncov2}{Number of "other" covariates}
  \item{beta2.vec}{Vector of coefficient values for "other" covariates}
  \item{C}{Simulated rattlesnake counts}
}
\description{
Simulate counts of rattlesnakes in Virginia
}
\examples{
str(dat <- simDat18())  # With default arguments

#### First variant of data simulation: beta1.vec is identical, beta2.vec is not
# Variant B: execute when you want to play with a small data set
set.seed(18)
trainDat <- simDat18(nSites = 50, beta1.vec = c(1, 0.2, 0.5, 1, -1), ncov2 = 10,
                     beta2.vec = rnorm(10, 0, 0.1), show.plot = TRUE)
testDat <- simDat18(nSites = 50, beta1.vec = c(1, 0.2, 0.5, 1, -1), ncov2 = 10,
                    beta2.vec = rnorm(10, 0, 0.1), show.plot = TRUE)
# Note how relatively different the two realizations of the SAME process are  

#### Second variant of data simulation: both beta1.vec and beta2.vec are identical

# Variant B: execute when you want to play with a small data set
set.seed(18)
beta2.vec <- rnorm(10, 0, 0.1)
trainDat <- simDat18(nSites = 50, beta1.vec = c(2, 0.2, 0.5, 1, -1), ncov2 = 10,
                     beta2.vec = beta2.vec, show.plot = TRUE)
testDat <- simDat18(nSites = 50, beta1.vec = c(2, 0.2, 0.5, 1, -1), ncov2 = 10,
                    beta2.vec = beta2.vec, show.plot = TRUE)
# Note how relatively different the two realizations of the SAME process are

}
\author{
Marc Kéry
}
