% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat20}
\alias{simDat20}
\title{Simulate data for Chapter 20: Integrated model}
\usage{
simDat20(
  nsites1 = 500,
  nsites2 = 1000,
  nsites3 = 2000,
  mean.lam = 2,
  beta = -2
)
}
\arguments{
\item{nsites1}{Number of sites in regular count dataset}

\item{nsites2}{Number of sites in zero-truncated count dataset}

\item{nsites3}{Number of sites in detection/non-detection dataset}

\item{mean.lam}{Mean site abundance}

\item{beta}{Slope for elevation covariate}
}
\value{
A list of simulated data and parameters.
  \item{nsites1}{Number of sites in regular count dataset}
  \item{nsites2}{Number of sites in zero-truncated count dataset}
  \item{nsites3}{Number of sites in detection/non-detection dataset}
  \item{mean.lam}{Mean site abundance}
  \item{beta}{Slope for elevation covariate}
  \item{C1}{Simulated regular counts from dataset 1}
  \item{C2}{Simulated regular counts from dataset 2}
  \item{C3}{Simulated regular counts from dataset 3}
  \item{ztC2}{Simulated zero-truncated counts from dataset 2}
  \item{y}{Simulated detection/non-detection data from dataset 3}
}
\description{
Simulate three count datasets under different data collection conditions
}
\examples{
str(dat <- simDat20())             # Implicit default arguments

# Revert to an 'integrated Poisson/binomial model-of-the-mean': no effect of elevation on abundance
str(dat <- simDat20(nsites1 = 500, nsites2 = 1000, nsites3 = 2000, mean.lam = 2, beta = 0))

}
\author{
Marc Kéry
}
