% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat73}
\alias{simDat73}
\title{Simulate data for Chapter 7.3: ANOVA with random effects of population}
\usage{
simDat73(nPops = 10, nSample = 12, pop.grand.mean = 50, pop.sd = 3, sigma = 5)
}
\arguments{
\item{nPops}{Number of populations}

\item{nSample}{Samples from each population}

\item{pop.grand.mean}{Mean of population means (hyperparameter)}

\item{pop.sd}{Standard deviation of population means (hyperparameter)}

\item{sigma}{Value for the residual standard deviation}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nSample}{Number of samples per population}
  \item{pop.grand.mean}{Mean of population means}
  \item{pop.sd}{SD of population means}
  \item{sigma}{Residual SD}
  \item{pop}{Indicator for population number}
  \item{pop.means}{Simulated population means}
  \item{eps}{Simulated residuals}
  \item{y}{Simulated lengths}
}
\description{
Simulate snout-vent length measurements of nSample smooth snakes in each of nPops populations.
Data are simulated under the assumptions of a model with random effects of populations
}
\examples{
str(dat <- simDat73())      # Implicit default arguments
# More pops, more snakes in each, more among-population variability
str(dat <- simDat73(nPops = 20, nSample = 30, pop.sd = 8)) 

# Revert to "model-of-the-mean" (larger sample size to minimize sampling variability)
str(dat <- simDat73(nSample = 1000, pop.sd = 0, sigma = 5))

}
\author{
Marc Kéry
}
