% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AVGAS.R
\name{AVGAS}
\alias{AVGAS}
\title{A Variable selection using Genetic AlgorithmS}
\usage{
AVGAS(
  X,
  y,
  heredity = "Strong",
  nmain.p,
  r1,
  r2,
  sigma = NULL,
  interaction.ind = NULL,
  lambda = 10,
  q = 40,
  allout = "No",
  interonly = "No",
  pi1 = 0.32,
  pi2 = 0.32,
  pi3 = 0.32,
  aprob = 0.9,
  dprob = 0.9,
  aprobm = 0.1,
  aprobi = 0.9,
  dprobm = 0.9,
  dprobi = 0.1,
  take = 3
)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} by \code{nmain.p}. Note that the two-way interaction effects should not
be included in \code{X} because this function automatically generates the
corresponding two-way interaction effects if needed.}

\item{y}{Response variable. A \code{n}-dimensional vector, where \code{n} is the number
of observations in \code{X}.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{nmain.p}{A numeric value that represents the total number of main effects
in \code{X}.}

\item{r1}{A numeric value indicating the maximum number of main effects. This number
can be different from the \code{r1} defined in \code{\link{detect}}.}

\item{r2}{A numeric value indicating the maximum number of interaction effects. This number
can be different from the \code{r1} defined in \code{\link{detect}}.}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. In such case, this function automatically estimate sigma using root mean
square error (RMSE). Default is NULL. Otherwise, users need to enter a numeric value.}

\item{interaction.ind}{A two-column numeric matrix containing all possible
two-way interaction effects. It must be generated outside of this function
using \code{t(utils::combn())}. See Example section for details.}

\item{lambda}{A numeric value defined by users. Default is 10.
For guidance on selecting an appropriate value, please refer to the Details section.}

\item{q}{A numeric value indicating the number of models in each generation (e.g.,
the population size). Default is 40.}

\item{allout}{Whether to print all outputs from this function. A "Yes" or "No"
logical vector. Default is "No". See Value section for details.}

\item{interonly}{Whether or not to consider fitted models with only two-way
interaction effects. A “Yes" or "No" logical vector. Default is "No".}

\item{pi1}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{pi2}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{pi3}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{aprob}{A numeric value between 0 and 1, defined by users.
The addition probability during mutation. Default is 0.9.}

\item{dprob}{A numeric value between 0 and 1, defined by users.
The deletion probability during mutation. Default is 0.9.}

\item{aprobm}{A numeric value between 0 and 1, defined by users.
The main effect addition probability during addition. Default is 0.1.}

\item{aprobi}{A numeric value between 0 and 1, defined by users.
The interaction effect addition probability during addition. Default is 0.9.}

\item{dprobm}{A numeric value between 0 and 1, defined by users.
The main effect deletion probability during deletion. Default is 0.9.}

\item{dprobi}{A numeric value between 0 and 1, defined by users.
The interaction effect deletion probability during deletion. Default is 0.1.}

\item{take}{Only used when \code{allout = "No"}. Number of top candidate models
to display. Default is 3.}
}
\value{
A list of output. The components are:
\item{final_model}{The final selected model.}
\item{cleaned_candidate_model}{All candidate models where each row corresponding
to a fitted model; the first 1 to \code{r1 + r2} columns representing the predictor
indices in that model, and the last column is a numeric value representing the
ABC score of that fitted model. Duplicated models are not allowed.}
\item{InterRank}{Rank of all candidate interaction effects. A two-column numeric
matrix. The first column contains indices of ranked two-way interaction effects, and the
second column contains its corresponding ABC score.}
}
\description{
A Variable selection using Genetic AlgorithmS
}
\examples{
# allout = "No"


# allout = "Yes"

}
\seealso{
\code{\link{initial}}, \code{\link{cross}}, \code{\link{mut}}, \code{\link{ABC}}, \code{\link{Genone}}, and \code{\link{Extract}}.
}
