% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put.R
\name{kinesis_put_record}
\alias{kinesis_put_record}
\title{Write a record to a Kinesis Stream}
\usage{
kinesis_put_record(stream, region = "us-west-1", data, partitionKey)
}
\arguments{
\item{stream}{stream name (string)}

\item{region}{AWS region (string)}

\item{data}{data blog (string)}

\item{partitionKey}{determines which shard in the stream the data record is assigned to, eg username, stock symbol etc (string)}
}
\value{
invisible list including the shard id and sequence number
}
\description{
Write a record to a Kinesis Stream
}
\examples{
\dontrun{
df <- mtcars[1, ]
str(kinesis_put_record('test-AWR', data = jsonlite::toJSON(df), partitionKey = row.names(df)))
}
}
\references{
\url{https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/services/kinesis/model/PutRecordRequest.html}
}
