% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qqplot.accept_reject}
\alias{qqplot.accept_reject}
\title{QQ-Plot
Plot the QQ-Plot between observed quantiles and theoretical quantiles.}
\usage{
\method{qqplot}{accept_reject}(
  x,
  alpha = 0.5,
  color_points = "#F890C2",
  color_line = "#BB9FC9",
  size_points = 1,
  size_line = 1,
  ...
)
}
\arguments{
\item{x}{Object of the class accept_reject returned by the function \code{accept_reject()}.}

\item{alpha}{Transparency of the points and reference line representing where
the quantiles should be (theoretical quantiles).}

\item{color_points}{Color of the points (default is \code{"#F890C2"}).}

\item{color_line}{Color of the reference line (detault is \code{"#BB9FC9"}).}

\item{size_points}{Size of the points (default is \code{1}).}

\item{size_line}{Thickness of the reference line (default is \code{1}).}

\item{...}{Additional arguments for the \code{quantile()} function. For instance,
it's possible to change the algorithm type for quantile calculation.}
}
\value{
An object of classes \code{gg} and \code{ggplot} with the QQ-Plot between the
observed quantiles generated by the return of the function \code{accept_reject()}
and the theoretical quantiles of the true distribution.
}
\description{
QQ-Plot
Plot the QQ-Plot between observed quantiles and theoretical quantiles.
}
\details{
The function \code{qqplot.accept_reject()} for samples larger than ten thousand,
the \code{geom_scattermost()} function from the
\href{https://CRAN.R-project.org/package=scattermore}{\strong{scattermore}} library
is used to plot the points, as it is more efficient than \code{geom_point()} from
the \href{https://CRAN.R-project.org/package=ggplot2}{\strong{ggplot2}} library.
}
\examples{
set.seed(0) # setting a seed for reproducibility

x <- accept_reject(
  n = 2000L,
  f = dbinom,
  continuous = FALSE,
  args_f = list(size = 5, prob = 0.5),
  xlim = c(0, 5)
)
qqplot(x)

y <- accept_reject(
  n = 1000L,
  f = dnorm,
  continuous = TRUE,
  args_f = list(mean = 0, sd = 1),
  xlim = c(-4, 4)
)
qqplot(y)

}
\seealso{
\code{\link[=qqplot.accept_reject]{qqplot.accept_reject()}}, \code{\link[=accept_reject]{accept_reject()}}, \code{\link[=plot.accept_reject]{plot.accept_reject()}}, \code{\link[=inspect]{inspect()}} and
\code{\link[=qqplot]{qqplot()}}.
}
