% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotherms.R
\name{langmuir_model}
\alias{langmuir_model}
\title{Langmuir Isotherm Model}
\usage{
langmuir_model(Ce, Qe)
}
\arguments{
  \item{Ce}{Numeric vector of equilibrium concentrations.}

  \item{Qe}{Numeric vector of amount adsorbed.}
}
\value{
A named list of Langmuir parameters and model details.
}
\description{
The Langmuir isotherm assumes monolayer adsorption onto a surface with a finite number of identical sites.
It is characterized by uniform energies of adsorption onto the surface and no transmigration of adsorbate
in the plane of the surface. The model is described by the equation:

\deqn{Q = \frac{Q_{\max} \cdot K_L \cdot C_e}{1 + K_L \cdot C_e}}

where \eqn{Q} is the amount adsorbed, \eqn{C_e} is the equilibrium concentration, \eqn{Q_{\max}} is the maximum adsorption capacity,
and \eqn{K_L} is the Langmuir constant.

For more information, see Langmuir (1918): \doi{https://doi.org/10.1021/ja02242a004}
}
\examples{
Ce <- c(1, 2, 3, 4, 5)
Qe <- c(0.8, 1.5, 2.1, 2.6, 2.9)
result <- langmuir_model(Ce, Qe)
print(result)
}
