% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bargraph2_function.R
\name{bar_graph2}
\alias{bar_graph2}
\title{Graph: Bar graph for one factor model 2}
\usage{
bar_graph2(
  model,
  point.color = "black",
  point.size = 2,
  point.shape = 16,
  text.color = "black",
  label.color = "black",
  bar.color = "black",
  title.size = 14,
  y.text = 0,
  add.info = NA,
  y.info = 0,
  width.bar = 0,
  color.info = "black",
  fill = "lightblue"
)
}
\arguments{
\item{model}{DIC, DBC or DQL object}

\item{point.color}{Point color}

\item{point.size}{Point size}

\item{point.shape}{Format point}

\item{text.color}{Text color}

\item{label.color}{Label color}

\item{bar.color}{Errorbar color}

\item{title.size}{Title size}

\item{y.text}{Y-axis height for x-axis legend}

\item{add.info}{Add other information}

\item{y.info}{Y-axis height for other information}

\item{width.bar}{Width error bar}

\item{color.info}{Color text information}

\item{fill}{Fill bars}
}
\value{
Returns a bar chart for one factor
}
\description{
This is a function of the bar graph for one factor
}
\examples{
data("laranja")
a=with(laranja, DBC(trat, bloco, resp,
     mcomp = "sk",angle=45,sup = 10,
     family = "serif",
     ylab = "Number of fruits/plants"))
bar_graph2(a)
bar_graph2(a,fill="darkblue",point.color="orange",text.color='white')
}
\seealso{
\link{barplot_positive}, \link{plot_TH}, \link{plot_TH1}, \link{corgraph}, \link{spider_graph}, \link{line_plot}, \link{plot_cor}, \link{plot_interaction}, \link{plot_jitter}, \link{seg_graph}, \link{TBARPLOT.reverse}
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
