% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CECrule.R
\name{CECrule}
\alias{CECrule}
\title{Constrained equal contributions rule}
\usage{
CECrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{CECrule} calculates the contribution vector selected by the CEC rule.
}
\details{
Let \eqn{N^i_{-}\{j\in N:c_j<c_i\}}. For each \eqn{c\in C^N} and each \eqn{i\in N}, the constrained equal contributions rule is defined by
\deqn{
\text{CEC}_i(c)=\text{min}\left\{\dfrac{1}{r-i+1}\left(c_r-\sum\limits_{j\in N^i_{-}}\text{CEC}_j(c)\right):r=1,\dots,n\right\}.
}
This rule offers a different approach to achieving equality.
Contributions are distributed as evenly as possible while ensuring compliance with the no-subsidy constraints.

The contribution selected by the CEC rule for a problem \eqn{c \in C^N} coincides with the payoff vector assigned
by the Dutta-Ray solution (denoted by \eqn{\text{EA}}) to the associated airport game \eqn{v\in G^N}, that is, \eqn{\text{CEC}(c)=\text{EA}(v)}.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
CECrule(c)

}
\references{
Aadland, D. and Kolpin, V. (1998). Shared irrigation costs: an empirical and axiomatic analysis.
\emph{Mathematical Social Sciences}, 35, 203-218.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{SIGMArule}}, \code{\link{basicrule}}, \code{\link{weightedrule}}, \code{\link{clonesrule}}, \code{\link{hierarchicalrule}}
}
